/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.config.model;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.opennms.netmgt.telemetry.config.api.AdapterDefinition;
import org.opennms.netmgt.telemetry.config.model.PackageConfig;
import org.opennms.netmgt.telemetry.config.model.Parameter;
import org.opennms.netmgt.telemetry.config.model.QueueConfig;

@XmlRootElement(name="adapter")
@XmlAccessorType(value=XmlAccessType.NONE)
public class AdapterConfig
implements AdapterDefinition {
    @XmlTransient
    private QueueConfig queue;
    @XmlAttribute(name="name", required=true)
    private String name;
    @XmlAttribute(name="class-name", required=true)
    private String className;
    @XmlAttribute(name="enabled")
    private boolean enabled;
    @XmlElement(name="parameter")
    private List<Parameter> parameters = new ArrayList<Parameter>();
    @XmlElement(name="package")
    private List<PackageConfig> packages = new ArrayList<PackageConfig>();

    public QueueConfig getQueue() {
        return this.queue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @XmlTransient
    public String getFullName() {
        return String.format("%s.%s", this.queue.getName(), this.getName());
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public Map<String, String> getParameterMap() {
        return this.parameters.stream().collect(Collectors.toMap(Parameter::getKey, Parameter::getValue));
    }

    public List<PackageConfig> getPackages() {
        return this.packages;
    }

    public void setPackages(List<PackageConfig> packages) {
        this.packages = packages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AdapterConfig that = (AdapterConfig)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.className, that.className) && Objects.equals(this.enabled, that.enabled) && Objects.equals(this.parameters, that.parameters) && Objects.equals(this.packages, that.packages);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.className, this.enabled, this.parameters, this.packages);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("class-name", (Object)this.className).add("enabled", this.enabled).addValue(this.parameters).add("packages", this.packages).toString();
    }

    public void afterUnmarshal(Unmarshaller u, Object parent) {
        this.queue = (QueueConfig)parent;
    }
}

