/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra.search;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.inject.Inject;
import org.opennms.newts.api.Context;
import org.opennms.newts.api.Resource;
import org.opennms.newts.api.search.QueryBuilder;
import org.opennms.newts.api.search.SearchResults;
import org.opennms.newts.cassandra.search.CassandraSearcher;

public class CassandraResourceTreeWalker {
    private static final Resource TOP_LEVEL_RESOURCE = new Resource("_root");
    private final CassandraSearcher m_searcher;

    @Inject
    public CassandraResourceTreeWalker(CassandraSearcher searcher) {
        this.m_searcher = (CassandraSearcher)Preconditions.checkNotNull((Object)searcher, (Object)"searcher argument");
    }

    public void breadthFirstSearch(Context context, SearchResultVisitor visitor) {
        this.breadthFirstSearch(context, visitor, TOP_LEVEL_RESOURCE);
    }

    public void breadthFirstSearch(Context context, SearchResultVisitor visitor, Resource root) {
        LinkedList queue = Lists.newLinkedList();
        queue.add(root);
        while (!queue.isEmpty()) {
            Resource r = (Resource)queue.remove();
            for (SearchResults.Result result : this.m_searcher.search(context, QueryBuilder.matchKeyAndValue((String)"_parent", (String)r.getId()))) {
                if (!visitor.visit(result)) {
                    return;
                }
                queue.add(result.getResource());
            }
        }
    }

    public void depthFirstSearch(Context context, SearchResultVisitor visitor) {
        this.depthFirstSearch(context, visitor, TOP_LEVEL_RESOURCE);
    }

    public void depthFirstSearch(Context context, SearchResultVisitor visitor, Resource root) {
        ArrayDeque stack = Queues.newArrayDeque();
        boolean skipFirstVisit = true;
        SearchResults initialResults = new SearchResults();
        initialResults.addResult(root, new ArrayList(0));
        stack.add(initialResults.iterator().next());
        while (!stack.isEmpty()) {
            SearchResults.Result r = (SearchResults.Result)stack.pop();
            if (skipFirstVisit) {
                skipFirstVisit = false;
            } else if (!visitor.visit(r)) {
                return;
            }
            ImmutableList results = ImmutableList.copyOf((Iterable)this.m_searcher.search(context, QueryBuilder.matchKeyAndValue((String)"_parent", (String)r.getResource().getId())));
            for (SearchResults.Result result : results.reverse()) {
                stack.push(result);
            }
        }
    }

    public static interface SearchResultVisitor {
        public boolean visit(SearchResults.Result var1);
    }
}

