/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.mapper.v2;

import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsEventParameter;
import org.opennms.netmgt.model.OnmsMonitoringSystem;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.web.rest.mapper.v2.EventMapper;
import org.opennms.web.rest.model.v2.EventDTO;
import org.opennms.web.rest.model.v2.EventParameterDTO;
import org.opennms.web.rest.model.v2.ServiceTypeDTO;
import org.springframework.stereotype.Component;

@Component
public class EventMapperImpl
extends EventMapper {
    @Override
    public EventDTO eventToEventDTO(OnmsEvent event) {
        if (event == null) {
            return null;
        }
        EventDTO eventDTO = new EventDTO();
        eventDTO.setUei(event.getEventUei());
        eventDTO.setTime(event.getEventTime());
        eventDTO.setHost(event.getEventHost());
        eventDTO.setSource(event.getEventSource());
        eventDTO.setIpAddress(event.getIpAddr());
        eventDTO.setSnmpHost(event.getEventSnmpHost());
        eventDTO.setSnmp(event.getEventSnmp());
        eventDTO.setCreateTime(event.getEventCreateTime());
        eventDTO.setDescription(event.getEventDescr());
        eventDTO.setLogGroup(event.getEventLogGroup());
        eventDTO.setLogMessage(event.getEventLogMsg());
        eventDTO.setPathOutage(event.getEventPathOutage());
        eventDTO.setCorrelation(event.getEventCorrelation());
        eventDTO.setSuppressedCount(event.getEventSuppressedCount());
        eventDTO.setOperatorInstructions(event.getEventOperInstruct());
        eventDTO.setAutoAction(event.getEventAutoAction());
        eventDTO.setOperatorAction(event.getEventOperAction());
        eventDTO.setOperationActionMenuText(event.getEventOperActionMenuText());
        eventDTO.setNotification(event.getEventNotification());
        eventDTO.setTroubleTicket(event.getEventTTicket());
        eventDTO.setTroubleTicketState(event.getEventTTicketState());
        eventDTO.setMouseOverText(event.getEventMouseOverText());
        eventDTO.setLog(event.getEventLog());
        eventDTO.setDisplay(event.getEventDisplay());
        eventDTO.setAckUser(event.getEventAckUser());
        eventDTO.setAckTime(event.getEventAckTime());
        eventDTO.setLocation(this.eventDistPollerLocation(event));
        eventDTO.setSeverity(event.getSeverityLabel());
        if (event.getId() != null) {
            eventDTO.setId(Integer.valueOf(event.getId().intValue()));
        }
        eventDTO.setServiceType(this.serviceTypeToServiceTypeDTO(event.getServiceType()));
        eventDTO.setNodeId(event.getNodeId());
        eventDTO.setNodeLabel(event.getNodeLabel());
        eventDTO.setIfIndex(event.getIfIndex());
        this.fillEvent(event, eventDTO);
        return eventDTO;
    }

    @Override
    public OnmsEvent eventDTOToEvent(EventDTO event) {
        if (event == null) {
            return null;
        }
        OnmsEvent onmsEvent = new OnmsEvent();
        onmsEvent.setDistPoller(this.eventDTOToOnmsMonitoringSystem(event));
        onmsEvent.setEventUei(event.getUei());
        onmsEvent.setEventTime(event.getTime());
        onmsEvent.setEventHost(event.getHost());
        onmsEvent.setEventSource(event.getSource());
        onmsEvent.setIpAddr(event.getIpAddress());
        onmsEvent.setEventSnmpHost(event.getSnmpHost());
        onmsEvent.setEventSnmp(event.getSnmp());
        onmsEvent.setEventCreateTime(event.getCreateTime());
        onmsEvent.setEventDescr(event.getDescription());
        onmsEvent.setEventLogGroup(event.getLogGroup());
        onmsEvent.setEventLogMsg(event.getLogMessage());
        onmsEvent.setEventPathOutage(event.getPathOutage());
        onmsEvent.setEventCorrelation(event.getCorrelation());
        onmsEvent.setEventSuppressedCount(event.getSuppressedCount());
        onmsEvent.setEventOperInstruct(event.getOperatorInstructions());
        onmsEvent.setEventAutoAction(event.getAutoAction());
        onmsEvent.setEventOperAction(event.getOperatorAction());
        onmsEvent.setEventOperActionMenuText(event.getOperationActionMenuText());
        onmsEvent.setEventNotification(event.getNotification());
        onmsEvent.setEventTTicket(event.getTroubleTicket());
        onmsEvent.setEventTTicketState(event.getTroubleTicketState());
        onmsEvent.setEventMouseOverText(event.getMouseOverText());
        onmsEvent.setEventLog(event.getLog());
        onmsEvent.setEventDisplay(event.getDisplay());
        onmsEvent.setEventAckUser(event.getAckUser());
        onmsEvent.setEventAckTime(event.getAckTime());
        onmsEvent.setSeverityLabel(event.getSeverity());
        if (event.getId() != null) {
            onmsEvent.setId(Long.valueOf(event.getId().longValue()));
        }
        onmsEvent.setServiceType(this.serviceTypeDTOToOnmsServiceType(event.getServiceType()));
        onmsEvent.setIfIndex(event.getIfIndex());
        return onmsEvent;
    }

    @Override
    public ServiceTypeDTO serviceTypeToServiceTypeDTO(OnmsServiceType serviceType) {
        if (serviceType == null) {
            return null;
        }
        ServiceTypeDTO serviceTypeDTO = new ServiceTypeDTO();
        serviceTypeDTO.setId(serviceType.getId());
        serviceTypeDTO.setName(serviceType.getName());
        return serviceTypeDTO;
    }

    @Override
    public EventParameterDTO eventParameterToEventParameterDTO(OnmsEventParameter eventParameter) {
        if (eventParameter == null) {
            return null;
        }
        EventParameterDTO eventParameterDTO = new EventParameterDTO();
        eventParameterDTO.setName(eventParameter.getName());
        eventParameterDTO.setValue(eventParameter.getValue());
        eventParameterDTO.setType(eventParameter.getType());
        return eventParameterDTO;
    }

    private String eventDistPollerLocation(OnmsEvent onmsEvent) {
        if (onmsEvent == null) {
            return null;
        }
        OnmsMonitoringSystem distPoller = onmsEvent.getDistPoller();
        if (distPoller == null) {
            return null;
        }
        String location = distPoller.getLocation();
        if (location == null) {
            return null;
        }
        return location;
    }

    protected OnmsMonitoringSystem eventDTOToOnmsMonitoringSystem(EventDTO eventDTO) {
        if (eventDTO == null) {
            return null;
        }
        OnmsMonitoringSystem onmsMonitoringSystem = new OnmsMonitoringSystem();
        onmsMonitoringSystem.setLocation(eventDTO.getLocation());
        return onmsMonitoringSystem;
    }

    protected OnmsServiceType serviceTypeDTOToOnmsServiceType(ServiceTypeDTO serviceTypeDTO) {
        if (serviceTypeDTO == null) {
            return null;
        }
        OnmsServiceType onmsServiceType = new OnmsServiceType();
        onmsServiceType.setId(serviceTypeDTO.getId());
        onmsServiceType.setName(serviceTypeDTO.getName());
        return onmsServiceType;
    }
}

