/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.util;

import java.nio.Buffer;
import java.nio.ByteBuffer;

public class BufferHandler {
    public static ByteBuffer shareContent(ByteBuffer byteBuffer) {
        ByteBuffer duplicated = BufferHandler.duplicate(byteBuffer);
        if (BufferHandler.position(byteBuffer) > 0) {
            BufferHandler.flip(duplicated);
        }
        return duplicated;
    }

    public static <T extends Buffer> T flip(T buffer) {
        return (T)buffer.flip();
    }

    public static <T extends Buffer> int position(T buffer) {
        return buffer.position();
    }

    public static ByteBuffer duplicate(ByteBuffer buffer) {
        return buffer.duplicate();
    }

    public static <T extends Buffer> int limit(T buffer) {
        return buffer.limit();
    }

    public static byte[] toByteArray(ByteBuffer byteBuffer) {
        byteBuffer = BufferHandler.shareContent(byteBuffer);
        byte[] result = new byte[BufferHandler.limit(byteBuffer)];
        byteBuffer.get(result, 0, result.length);
        return result;
    }
}

