/*
 * Decompiled with CFR 0.152.
 */
package io.github.toolfactory.jvm.function.catalog;

import io.github.toolfactory.jvm.ObjectProvider;
import io.github.toolfactory.jvm.function.catalog.AllocateInstanceFunction;
import io.github.toolfactory.jvm.function.catalog.ConsulterSupplier;
import io.github.toolfactory.jvm.function.catalog.ConsulterSupplyFunction;
import io.github.toolfactory.jvm.function.catalog.DefineHookClassFunction;
import io.github.toolfactory.jvm.function.catalog.SetFieldValueFunction;
import io.github.toolfactory.jvm.function.catalog.ThrowExceptionFunction;
import io.github.toolfactory.jvm.function.template.BiConsumer;
import io.github.toolfactory.jvm.function.util.BiConsumerAdapter;
import io.github.toolfactory.jvm.function.util.Resources;
import io.github.toolfactory.jvm.function.util.Streams;
import io.github.toolfactory.narcissus.Narcissus;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.Map;

public abstract class SetAccessibleFunction<B>
extends BiConsumerAdapter<B, AccessibleObject, Boolean> {
    ThrowExceptionFunction throwExceptionFunction;

    public SetAccessibleFunction(Map<Object, Object> context) {
        ObjectProvider functionProvider = ObjectProvider.get(context);
        this.throwExceptionFunction = functionProvider.getOrBuildObject(ThrowExceptionFunction.class, context);
    }

    public static abstract class Native<B>
    extends SetAccessibleFunction<B> {
        public Native(Map<Object, Object> context) {
            super(context);
        }

        public static class ForJava7
        extends Native<BiConsumer<AccessibleObject, Boolean>> {
            public ForJava7(Map<Object, Object> context) {
                super(context);
                this.setFunction(new BiConsumer<AccessibleObject, Boolean>(){

                    @Override
                    public void accept(AccessibleObject accessibleObject, Boolean flag) {
                        Narcissus.setAccessible((AccessibleObject)accessibleObject, (boolean)flag);
                    }
                });
            }

            @Override
            public void accept(AccessibleObject accessibleObject, Boolean flag) {
                ((BiConsumer)this.function).accept(accessibleObject, flag);
            }
        }
    }

    public static class ForJava9
    extends SetAccessibleFunction<java.util.function.BiConsumer<AccessibleObject, Boolean>> {
        public ForJava9(Map<Object, Object> context) throws NoSuchMethodException, SecurityException, IllegalAccessException, IOException, NoSuchFieldException {
            super(context);
            try (InputStream inputStream = Resources.getAsInputStream(this.getClass().getClassLoader(), this.getClass().getPackage().getName().replace(".", "/") + "/AccessibleSetterInvokerForJDK9.bwc");){
                ObjectProvider functionProvider = ObjectProvider.get(context);
                Class methodHandleWrapperClass = (Class)functionProvider.getOrBuildObject(DefineHookClassFunction.class, context).apply(AccessibleObject.class, Streams.toByteArray(inputStream));
                functionProvider.getOrBuildObject(SetFieldValueFunction.class, context).accept(methodHandleWrapperClass, methodHandleWrapperClass.getDeclaredField("methodHandleRetriever"), functionProvider.getOrBuildObject(ConsulterSupplyFunction.class, context).apply(methodHandleWrapperClass));
                this.setFunction((java.util.function.BiConsumer)functionProvider.getOrBuildObject(AllocateInstanceFunction.class, context).apply(methodHandleWrapperClass));
            }
        }

        @Override
        public void accept(AccessibleObject accessibleObject, Boolean flag) {
            ((java.util.function.BiConsumer)this.function).accept(accessibleObject, flag);
        }
    }

    public static class ForJava7
    extends SetAccessibleFunction<BiConsumer<AccessibleObject, Boolean>> {
        public ForJava7(Map<Object, Object> context) throws NoSuchMethodException, SecurityException, IllegalAccessException {
            super(context);
            Method accessibleSetterMethod = AccessibleObject.class.getDeclaredMethod("setAccessible0", AccessibleObject.class, Boolean.TYPE);
            ObjectProvider functionProvider = ObjectProvider.get(context);
            final MethodHandle accessibleSetterMethodHandle = functionProvider.getOrBuildObject(ConsulterSupplier.class, context).get().unreflect(accessibleSetterMethod);
            this.setFunction(new BiConsumer<AccessibleObject, Boolean>(){

                @Override
                public void accept(AccessibleObject accessibleObject, Boolean flag) {
                    try {
                        accessibleSetterMethodHandle.invoke(accessibleObject, flag);
                    }
                    catch (Throwable exc) {
                        ForJava7.this.throwExceptionFunction.apply(exc, new Object[0]);
                    }
                }
            });
        }

        @Override
        public void accept(AccessibleObject accessibleObject, Boolean flag) {
            ((BiConsumer)this.function).accept(accessibleObject, flag);
        }
    }
}

