/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.implementations;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.service.Service;
import org.opennms.netmgt.config.service.ServiceConfiguration;
import org.opennms.upgrade.api.AbstractOnmsUpgrade;
import org.opennms.upgrade.api.OnmsUpgradeException;

public class EOLServiceConfigMigratorOffline
extends AbstractOnmsUpgrade {
    private File configFile;

    public EOLServiceConfigMigratorOffline() throws OnmsUpgradeException {
        try {
            this.configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SERVICE_CONF_FILE_NAME);
        }
        catch (IOException e) {
            throw new OnmsUpgradeException("Can't find Services Configuration file", e);
        }
    }

    @Override
    public int getOrder() {
        return 10;
    }

    @Override
    public String getDescription() {
        return "Fixes service-configuration.xml if necessary when upgrading to 17.0.0: HZN-545";
    }

    @Override
    public boolean requiresOnmsRunning() {
        return false;
    }

    @Override
    public void preExecute() throws OnmsUpgradeException {
        try {
            this.log("Backing up %s\n", this.configFile);
            this.zipFile(this.configFile);
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Can't backup service-configurations.xml because " + e.getMessage());
        }
    }

    @Override
    public void postExecute() throws OnmsUpgradeException {
        File zip = new File(this.configFile.getAbsolutePath() + ".zip");
        if (zip.exists()) {
            this.log("Removing backup %s\n", zip);
            FileUtils.deleteQuietly((File)zip);
        }
    }

    @Override
    public void rollback() throws OnmsUpgradeException {
        this.log("Restoring backup %s\n", this.configFile);
        File zip = new File(this.configFile.getAbsolutePath() + ".zip");
        FileUtils.deleteQuietly((File)this.configFile);
        this.unzipFile(zip, zip.getParentFile());
    }

    @Override
    public void execute() throws OnmsUpgradeException {
        String[] eol = new String[]{"OpenNMS:Name=Linkd", "OpenNMS:Name=Xmlrpcd", "OpenNMS:Name=XmlrpcProvisioner", "OpenNMS:Name=AccessPointMonitor", "OpenNMS:Name=PollerBackEnd"};
        try {
            ServiceConfiguration currentCfg = (ServiceConfiguration)JaxbUtils.unmarshal(ServiceConfiguration.class, (File)this.configFile);
            for (String serviceName : eol) {
                String eolServiceName;
                Service eolService = EOLServiceConfigMigratorOffline.getService(currentCfg, serviceName);
                if (eolService == null || !(eolServiceName = eolService.getName()).equals(serviceName)) continue;
                String displayName = serviceName.replace("OpenNMS:Name=", "");
                this.log("Disabling EOL service: " + displayName + "\n", new Object[0]);
                eolService.setEnabled(Boolean.valueOf(false));
            }
            StringWriter sw = new StringWriter();
            sw.write("<?xml version=\"1.0\"?>\n");
            sw.write("<!-- NOTE!!!!!!!!!!!!!!!!!!!\n");
            sw.write("The order in which these services are specified is important - for example, Eventd\n");
            sw.write("will need to come up last so that none of the event topic subcribers loose any event.\n");
            sw.write("\nWhen splitting services to run on mutiple VMs, the order of the services should be\n");
            sw.write("maintained\n");
            sw.write("-->\n");
            JaxbUtils.marshal((Object)currentCfg, (Writer)sw);
            FileWriter fw = new FileWriter(this.configFile);
            fw.write(sw.toString());
            fw.close();
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Can't fix services configuration because " + e.getMessage(), e);
        }
    }

    private static Service getService(ServiceConfiguration svcConfig, String serviceName) {
        for (Service s : svcConfig.getServices()) {
            if (!s.getName().equals(serviceName)) continue;
            return s;
        }
        return null;
    }
}

