/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.jce.provider;

import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import org.opennms.shaded.org.bouncycastle.asn1.DERObjectIdentifier;
import org.opennms.shaded.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.opennms.shaded.org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.opennms.shaded.org.bouncycastle.crypto.params.RSAKeyParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;

class RSAUtil {
    RSAUtil() {
    }

    static boolean isRsaOid(DERObjectIdentifier dERObjectIdentifier) {
        return dERObjectIdentifier.equals(PKCSObjectIdentifiers.rsaEncryption) || dERObjectIdentifier.equals(X509ObjectIdentifiers.id_ea_rsa) || dERObjectIdentifier.equals(PKCSObjectIdentifiers.id_RSASSA_PSS) || dERObjectIdentifier.equals(PKCSObjectIdentifiers.id_RSAES_OAEP);
    }

    static RSAKeyParameters generatePublicKeyParameter(RSAPublicKey rSAPublicKey) {
        return new RSAKeyParameters(false, rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
    }

    static RSAKeyParameters generatePrivateKeyParameter(RSAPrivateKey rSAPrivateKey) {
        if (rSAPrivateKey instanceof RSAPrivateCrtKey) {
            RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)rSAPrivateKey;
            return new RSAPrivateCrtKeyParameters(rSAPrivateCrtKey.getModulus(), rSAPrivateCrtKey.getPublicExponent(), rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ(), rSAPrivateCrtKey.getPrimeExponentP(), rSAPrivateCrtKey.getPrimeExponentQ(), rSAPrivateCrtKey.getCrtCoefficient());
        }
        RSAPrivateKey rSAPrivateKey2 = rSAPrivateKey;
        return new RSAKeyParameters(true, rSAPrivateKey2.getModulus(), rSAPrivateKey2.getPrivateExponent());
    }
}

