/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.jce.provider;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Permission;
import org.opennms.shaded.org.bouncycastle.jce.ProviderConfigurationPermission;
import org.opennms.shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.opennms.shaded.org.bouncycastle.jce.provider.asymmetric.ec.EC5Util;
import org.opennms.shaded.org.bouncycastle.jce.spec.ECParameterSpec;

public class ProviderUtil {
    private static final long MAX_MEMORY = Runtime.getRuntime().maxMemory();
    private static Permission BC_EC_LOCAL_PERMISSION = new ProviderConfigurationPermission(BouncyCastleProvider.PROVIDER_NAME, "threadLocalEcImplicitlyCa");
    private static Permission BC_EC_PERMISSION = new ProviderConfigurationPermission(BouncyCastleProvider.PROVIDER_NAME, "ecImplicitlyCa");
    private static ThreadLocal threadSpec = new ThreadLocal();
    private static volatile ECParameterSpec ecImplicitCaParams;

    static void setParameter(String string, Object object) {
        SecurityManager securityManager = System.getSecurityManager();
        if (string.equals("threadLocalEcImplicitlyCa")) {
            ECParameterSpec eCParameterSpec;
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_LOCAL_PERMISSION);
            }
            if ((eCParameterSpec = object instanceof ECParameterSpec || object == null ? (ECParameterSpec)object : EC5Util.convertSpec((java.security.spec.ECParameterSpec)object, false)) == null) {
                threadSpec.remove();
            } else {
                threadSpec.set(eCParameterSpec);
            }
        } else if (string.equals("ecImplicitlyCa")) {
            if (securityManager != null) {
                securityManager.checkPermission(BC_EC_PERMISSION);
            }
            ecImplicitCaParams = object instanceof ECParameterSpec || object == null ? (ECParameterSpec)object : EC5Util.convertSpec((java.security.spec.ECParameterSpec)object, false);
        }
    }

    public static ECParameterSpec getEcImplicitlyCa() {
        ECParameterSpec eCParameterSpec = (ECParameterSpec)threadSpec.get();
        if (eCParameterSpec != null) {
            return eCParameterSpec;
        }
        return ecImplicitCaParams;
    }

    static int getReadLimit(InputStream inputStream) throws IOException {
        if (inputStream instanceof ByteArrayInputStream) {
            return inputStream.available();
        }
        if (MAX_MEMORY > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)MAX_MEMORY;
    }
}

