/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.shaded.org.bouncycastle.jce.provider;

import java.security.AlgorithmParameterGeneratorSpi;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import javax.crypto.spec.DHGenParameterSpec;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.opennms.shaded.org.bouncycastle.crypto.generators.DHParametersGenerator;
import org.opennms.shaded.org.bouncycastle.crypto.generators.DSAParametersGenerator;
import org.opennms.shaded.org.bouncycastle.crypto.generators.ElGamalParametersGenerator;
import org.opennms.shaded.org.bouncycastle.crypto.generators.GOST3410ParametersGenerator;
import org.opennms.shaded.org.bouncycastle.crypto.params.DHParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.DSAParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.ElGamalParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.GOST3410Parameters;
import org.opennms.shaded.org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.opennms.shaded.org.bouncycastle.jce.spec.GOST3410ParameterSpec;
import org.opennms.shaded.org.bouncycastle.jce.spec.GOST3410PublicKeyParameterSetSpec;

public abstract class JDKAlgorithmParameterGenerator
extends AlgorithmParameterGeneratorSpi {
    protected SecureRandom random;
    protected int strength = 1024;

    protected void engineInit(int n, SecureRandom secureRandom) {
        this.strength = n;
        this.random = secureRandom;
    }

    public static class DES
    extends JDKAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for DES parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters algorithmParameters;
            byte[] byArray = new byte[8];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(byArray);
            try {
                algorithmParameters = AlgorithmParameters.getInstance("DES", BouncyCastleProvider.PROVIDER_NAME);
                algorithmParameters.init(new IvParameterSpec(byArray));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            return algorithmParameters;
        }
    }

    public static class DH
    extends JDKAlgorithmParameterGenerator {
        private int l = 0;

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (!(algorithmParameterSpec instanceof DHGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("DH parameter generator requires a DHGenParameterSpec for initialisation");
            }
            DHGenParameterSpec dHGenParameterSpec = (DHGenParameterSpec)algorithmParameterSpec;
            this.strength = dHGenParameterSpec.getPrimeSize();
            this.l = dHGenParameterSpec.getExponentSize();
            this.random = secureRandom;
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters algorithmParameters;
            DHParametersGenerator dHParametersGenerator = new DHParametersGenerator();
            if (this.random != null) {
                dHParametersGenerator.init(this.strength, 20, this.random);
            } else {
                dHParametersGenerator.init(this.strength, 20, new SecureRandom());
            }
            DHParameters dHParameters = dHParametersGenerator.generateParameters();
            try {
                algorithmParameters = AlgorithmParameters.getInstance("DH", BouncyCastleProvider.PROVIDER_NAME);
                algorithmParameters.init(new DHParameterSpec(dHParameters.getP(), dHParameters.getG(), this.l));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            return algorithmParameters;
        }
    }

    public static class DSA
    extends JDKAlgorithmParameterGenerator {
        protected void engineInit(int n, SecureRandom secureRandom) {
            if (n < 512 || n > 1024 || n % 64 != 0) {
                throw new InvalidParameterException("strength must be from 512 - 1024 and a multiple of 64");
            }
            this.strength = n;
            this.random = secureRandom;
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for DSA parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters algorithmParameters;
            DSAParametersGenerator dSAParametersGenerator = new DSAParametersGenerator();
            if (this.random != null) {
                dSAParametersGenerator.init(this.strength, 20, this.random);
            } else {
                dSAParametersGenerator.init(this.strength, 20, new SecureRandom());
            }
            DSAParameters dSAParameters = dSAParametersGenerator.generateParameters();
            try {
                algorithmParameters = AlgorithmParameters.getInstance("DSA", BouncyCastleProvider.PROVIDER_NAME);
                algorithmParameters.init(new DSAParameterSpec(dSAParameters.getP(), dSAParameters.getQ(), dSAParameters.getG()));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            return algorithmParameters;
        }
    }

    public static class ElGamal
    extends JDKAlgorithmParameterGenerator {
        private int l = 0;

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (!(algorithmParameterSpec instanceof DHGenParameterSpec)) {
                throw new InvalidAlgorithmParameterException("DH parameter generator requires a DHGenParameterSpec for initialisation");
            }
            DHGenParameterSpec dHGenParameterSpec = (DHGenParameterSpec)algorithmParameterSpec;
            this.strength = dHGenParameterSpec.getPrimeSize();
            this.l = dHGenParameterSpec.getExponentSize();
            this.random = secureRandom;
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters algorithmParameters;
            ElGamalParametersGenerator elGamalParametersGenerator = new ElGamalParametersGenerator();
            if (this.random != null) {
                elGamalParametersGenerator.init(this.strength, 20, this.random);
            } else {
                elGamalParametersGenerator.init(this.strength, 20, new SecureRandom());
            }
            ElGamalParameters elGamalParameters = elGamalParametersGenerator.generateParameters();
            try {
                algorithmParameters = AlgorithmParameters.getInstance("ElGamal", BouncyCastleProvider.PROVIDER_NAME);
                algorithmParameters.init(new DHParameterSpec(elGamalParameters.getP(), elGamalParameters.getG(), this.l));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            return algorithmParameters;
        }
    }

    public static class GOST3410
    extends JDKAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for GOST3410 parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters algorithmParameters;
            GOST3410ParametersGenerator gOST3410ParametersGenerator = new GOST3410ParametersGenerator();
            if (this.random != null) {
                gOST3410ParametersGenerator.init(this.strength, 2, this.random);
            } else {
                gOST3410ParametersGenerator.init(this.strength, 2, new SecureRandom());
            }
            GOST3410Parameters gOST3410Parameters = gOST3410ParametersGenerator.generateParameters();
            try {
                algorithmParameters = AlgorithmParameters.getInstance("GOST3410", BouncyCastleProvider.PROVIDER_NAME);
                algorithmParameters.init(new GOST3410ParameterSpec(new GOST3410PublicKeyParameterSetSpec(gOST3410Parameters.getP(), gOST3410Parameters.getQ(), gOST3410Parameters.getA())));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            return algorithmParameters;
        }
    }

    public static class RC2
    extends JDKAlgorithmParameterGenerator {
        RC2ParameterSpec spec = null;

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (algorithmParameterSpec instanceof RC2ParameterSpec) {
                this.spec = (RC2ParameterSpec)algorithmParameterSpec;
                return;
            }
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for RC2 parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters algorithmParameters;
            if (this.spec == null) {
                byte[] byArray = new byte[8];
                if (this.random == null) {
                    this.random = new SecureRandom();
                }
                this.random.nextBytes(byArray);
                try {
                    algorithmParameters = AlgorithmParameters.getInstance("RC2", BouncyCastleProvider.PROVIDER_NAME);
                    algorithmParameters.init(new IvParameterSpec(byArray));
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage());
                }
            }
            try {
                algorithmParameters = AlgorithmParameters.getInstance("RC2", BouncyCastleProvider.PROVIDER_NAME);
                algorithmParameters.init(this.spec);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
            return algorithmParameters;
        }
    }
}

