/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.handler.authorize;

import net.jradius.exception.RadiusException;
import net.jradius.handler.RadiusSessionHandler;
import net.jradius.packet.AccessAccept;
import net.jradius.packet.AccessChallenge;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.RadiusAttribute;
import net.jradius.server.JRadiusRequest;
import net.jradius.session.JRadiusSession;

public class PostAuthorizeClassHandler
extends RadiusSessionHandler {
    public boolean handle(JRadiusRequest request) throws RadiusException {
        RadiusAttribute attr;
        JRadiusSession session = request.getSession();
        if (session == null) {
            return this.noSessionFound(request);
        }
        RadiusPacket rep = request.getReplyPacket();
        if (!(rep instanceof AccessAccept) && !(rep instanceof AccessChallenge)) {
            return false;
        }
        Object[] attrs = rep.findAttributes(25L);
        if (attrs != null && session.getRadiusClass() == null) {
            byte[][] classes = new byte[attrs.length][];
            for (int i = 0; i < attrs.length; ++i) {
                RadiusAttribute attribute = (RadiusAttribute)attrs[i];
                classes[i] = (byte[])attribute.getValue().getValueObject();
            }
            session.setRadiusClass((byte[][])classes);
        }
        if ((attr = rep.findAttribute(24L)) != null) {
            byte[] val = (byte[])attr.getValue().getValueObject();
            session.setRadiusState(val);
        }
        rep.overwriteAttribute(AttributeFactory.newAttribute((long)(rep instanceof AccessAccept ? 25L : 24L), (byte[])("JRADIUS-CLASS:" + session.getSessionKey()).getBytes(), (boolean)rep.isRecyclable()));
        return false;
    }
}

