/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.client.auth;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509KeyManager;
import net.jradius.client.RadiusClient;
import net.jradius.client.auth.EAPAuthenticator;
import net.jradius.exception.RadiusException;
import net.jradius.log.RadiusLog;
import net.jradius.packet.RadiusPacket;
import net.jradius.tls.AlwaysValidVerifyer;
import net.jradius.tls.Certificate;
import net.jradius.tls.DefaultTlsClient;
import net.jradius.tls.TlsProtocolHandler;
import net.jradius.util.KeyStoreUtil;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1InputStream;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Object;
import org.opennms.shaded.org.bouncycastle.asn1.ASN1Sequence;
import org.opennms.shaded.org.bouncycastle.asn1.DEREncodable;
import org.opennms.shaded.org.bouncycastle.asn1.DERInteger;
import org.opennms.shaded.org.bouncycastle.asn1.DERObject;
import org.opennms.shaded.org.bouncycastle.asn1.DERObjectIdentifier;
import org.opennms.shaded.org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.opennms.shaded.org.bouncycastle.asn1.oiw.ElGamalParameter;
import org.opennms.shaded.org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.opennms.shaded.org.bouncycastle.asn1.pkcs.DHParameter;
import org.opennms.shaded.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.opennms.shaded.org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.opennms.shaded.org.bouncycastle.asn1.pkcs.RSAPrivateKeyStructure;
import org.opennms.shaded.org.bouncycastle.asn1.sec.ECPrivateKeyStructure;
import org.opennms.shaded.org.bouncycastle.asn1.sec.SECNamedCurves;
import org.opennms.shaded.org.bouncycastle.asn1.teletrust.TeleTrusTNamedCurves;
import org.opennms.shaded.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.opennms.shaded.org.bouncycastle.asn1.x509.DSAParameter;
import org.opennms.shaded.org.bouncycastle.asn1.x509.X509CertificateStructure;
import org.opennms.shaded.org.bouncycastle.asn1.x9.X962NamedCurves;
import org.opennms.shaded.org.bouncycastle.asn1.x9.X962Parameters;
import org.opennms.shaded.org.bouncycastle.asn1.x9.X9ECParameters;
import org.opennms.shaded.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.opennms.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.opennms.shaded.org.bouncycastle.crypto.params.DHParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.DHPrivateKeyParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.DSAParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.DSAPrivateKeyParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.ECDomainParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.ElGamalParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.ElGamalPrivateKeyParameters;
import org.opennms.shaded.org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;

public class EAPTLSAuthenticator
extends EAPAuthenticator {
    public static final String NAME = "eap-tls";
    private String keyFileType;
    private String keyFile;
    private String keyPassword;
    private String caFileType;
    private String caFile;
    private String caPassword;
    private Boolean trustAll = Boolean.FALSE;
    private ByteArrayOutputStream bout;
    private ByteArrayInputStream bin;
    private TlsProtocolHandler handler = new TlsProtocolHandler();
    private AlwaysValidVerifyer verifyer = new AlwaysValidVerifyer();
    private DefaultTlsClient tlsClient = null;
    private ByteBuffer receivedEAP = ByteBuffer.allocate(10000000);
    private KeyManager[] keyManagers = null;
    private TrustManager[] trustManagers = null;
    int state = 0;
    protected static final short TLS_START = 32;
    protected static final short TLS_MORE_FRAGMENTS = 64;
    protected static final short TLS_HAS_LENGTH = 128;
    protected static final int TLS_CLIENT_HELLO = 0;
    protected static final int TLS_SERVER_HELLO = 1;
    protected static final int TLS_APP_DATA = 2;
    protected byte[] eapFragmentedReply = null;
    protected int eapFragmentedOffset = 0;
    ByteArrayOutputStream appOutput = new ByteArrayOutputStream();

    public EAPTLSAuthenticator() {
        this.setEAPType(13);
        this.keyFileType = "pkcs12";
        this.keyPassword = "";
        this.caFileType = "pkcs12";
        this.caPassword = "";
    }

    public void setupRequest(RadiusClient c, RadiusPacket p) throws RadiusException, NoSuchAlgorithmException {
        super.setupRequest(c, p);
        this.init();
    }

    public void init() throws RadiusException {
        try {
            if (this.getKeyFile() != null) {
                this.keyManagers = KeyStoreUtil.loadKeyManager(this.getKeyFileType(), new FileInputStream(this.getKeyFile()), this.getKeyPassword());
            }
            if (this.getTrustAll().booleanValue()) {
                this.trustManagers = KeyStoreUtil.trustAllManager();
            } else if (this.getCaFile() != null) {
                this.trustManagers = KeyStoreUtil.loadTrustManager(this.getCaFileType(), new FileInputStream(this.getCaFile()), this.getCaPassword());
            }
            this.tlsClient = new DefaultTlsClient(this.verifyer);
            try {
                if (this.keyManagers != null && this.keyManagers.length > 0) {
                    X509CertificateStructure[] certs = null;
                    X509Certificate[] certChain = ((X509KeyManager)this.keyManagers[0]).getCertificateChain("");
                    PrivateKey key = ((X509KeyManager)this.keyManagers[0]).getPrivateKey("");
                    Vector<X509CertificateStructure> tmp = new Vector<X509CertificateStructure>();
                    for (X509Certificate cert : certChain) {
                        ByteArrayInputStream bis = new ByteArrayInputStream(cert.getEncoded());
                        ASN1InputStream ais = new ASN1InputStream(bis);
                        DERObject o = ais.readObject();
                        tmp.addElement(X509CertificateStructure.getInstance(o));
                        if (bis.available() <= 0) continue;
                        throw new IllegalArgumentException("Sorry, there is garbage data left after the certificate");
                    }
                    certs = new X509CertificateStructure[tmp.size()];
                    for (int i = 0; i < tmp.size(); ++i) {
                        certs[i] = (X509CertificateStructure)tmp.elementAt(i);
                    }
                    this.tlsClient.enableClientAuthentication(new Certificate(certs), EAPTLSAuthenticator.createKey(key.getEncoded()));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.handler.setSendCertificate(this.isCertificateRequired());
            this.handler.setKeyManagers(this.keyManagers);
            this.handler.setTrustManagers(this.trustManagers);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getAuthName() {
        return NAME;
    }

    public void setServerMode() {
        this.state = 1;
    }

    public void putAppBuffer(byte[] b) {
        try {
            this.appOutput.write(b);
        }
        catch (Exception e) {
            RadiusLog.error((String)e.getMessage(), (Throwable)e);
        }
    }

    public void putAppBuffer(byte[] b, int off, int len) {
        try {
            this.appOutput.write(b, off, len);
        }
        catch (Exception e) {
            RadiusLog.error((String)e.getMessage(), (Throwable)e);
        }
    }

    protected byte[] getAppBuffer() {
        byte[] b = this.appOutput.toByteArray();
        this.appOutput = new ByteArrayOutputStream();
        return b;
    }

    public byte[] doEAPType(byte id, byte[] data) throws RadiusException {
        ByteBuffer bb = ByteBuffer.wrap(data);
        byte dflags = bb.get();
        byte flags = 0;
        int dlen = 0;
        try {
            if ((dflags & 0x80) != 0) {
                dlen = bb.getInt();
            }
            if (bb.hasRemaining()) {
                this.receivedEAP.put(bb.array(), bb.position(), bb.remaining());
            } else if (this.eapFragmentedReply != null) {
                return this.nextFragment();
            }
            if ((dflags & 0x40) != 0) {
                return this.tlsResponse(flags, null);
            }
            switch (this.state) {
                case 0: {
                    ByteArrayInputStream is = new ByteArrayInputStream(this.receivedEAP.array(), this.receivedEAP.position(), this.receivedEAP.remaining());
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    this.handler.connect(is, os, this.tlsClient);
                    data = os.toByteArray();
                    this.state = 1;
                    break;
                }
                case 1: {
                    this.receivedEAP.flip();
                    ByteArrayInputStream is = new ByteArrayInputStream(this.receivedEAP.array(), this.receivedEAP.position(), this.receivedEAP.remaining());
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    short s = this.handler.updateConnectState(is, os);
                    data = os.toByteArray();
                    this.receivedEAP.clear();
                    if (s != 12) break;
                    this.state = 2;
                }
                case 2: {
                    this.receivedEAP.flip();
                    ByteArrayInputStream is = new ByteArrayInputStream(this.receivedEAP.array(), this.receivedEAP.position(), this.receivedEAP.remaining());
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    byte[] in = this.handler.readApplicationData(is, os);
                    try {
                        if (this.doTunnelAuthentication(id, in)) {
                            this.handler.writeApplicationData(is, os, this.getAppBuffer());
                        }
                    }
                    catch (Throwable e) {
                        RadiusLog.error((String)e.getMessage(), (Throwable)e);
                    }
                    data = os.toByteArray();
                    this.receivedEAP.clear();
                }
            }
            if (data != null && data.length > 1024) {
                this.eapFragmentedReply = data;
                return this.nextFragment();
            }
            return this.tlsResponse(flags, data);
        }
        catch (Exception e) {
            throw new RadiusException(e);
        }
    }

    protected byte[] nextFragment() {
        int left = this.eapFragmentedReply.length - this.eapFragmentedOffset;
        byte flags = 0;
        if (left > 1024) {
            left = 1024;
            flags = (byte)(flags | 0x40);
        }
        byte[] data = new byte[left];
        System.arraycopy(this.eapFragmentedReply, this.eapFragmentedOffset, data, 0, data.length);
        this.eapFragmentedOffset += data.length;
        if (this.eapFragmentedReply.length == this.eapFragmentedOffset) {
            this.eapFragmentedReply = null;
            this.eapFragmentedOffset = 0;
        }
        return this.tlsResponse(flags, data);
    }

    protected byte[] tlsResponse(byte flags, byte[] data) {
        int length = 1;
        if (data != null && data.length > 0) {
            length += data.length;
            if (flags != 0) {
                length += 4;
                flags = (byte)(flags | 0x80);
            }
        }
        byte[] response = new byte[length];
        response[0] = flags;
        if (data != null && data.length > 0) {
            if (flags == 0) {
                System.arraycopy(data, 0, response, 1, data.length);
            } else {
                --length;
                response[1] = (byte)(this.eapFragmentedReply.length >> 24 & 0xFF);
                response[2] = (byte)(this.eapFragmentedReply.length >> 16 & 0xFF);
                response[3] = (byte)(this.eapFragmentedReply.length >> 8 & 0xFF);
                response[4] = (byte)(this.eapFragmentedReply.length & 0xFF);
                System.arraycopy(data, 0, response, 5, data.length);
            }
        }
        return response;
    }

    protected boolean doTunnelAuthentication(byte id, byte[] in) throws Throwable {
        return false;
    }

    public String getCaFile() {
        return this.caFile;
    }

    public void setCaFile(String caFile) {
        this.caFile = caFile;
    }

    public String getCaFileType() {
        return this.caFileType;
    }

    public void setCaFileType(String caFileType) {
        this.caFileType = caFileType;
    }

    public String getKeyFile() {
        return this.keyFile;
    }

    public void setKeyFile(String keyFile) {
        this.keyFile = keyFile;
    }

    public String getKeyFileType() {
        return this.keyFileType;
    }

    public void setKeyFileType(String keyFileType) {
        this.keyFileType = keyFileType;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getCaPassword() {
        return this.caPassword;
    }

    public void setCaPassword(String caPassword) {
        this.caPassword = caPassword;
    }

    public Boolean getTrustAll() {
        return this.trustAll;
    }

    public void setTrustAll(Boolean trustAll) {
        this.trustAll = trustAll;
    }

    public static AsymmetricKeyParameter createKey(byte[] privateKeyInfoData) throws IOException {
        return EAPTLSAuthenticator.createKey(PrivateKeyInfo.getInstance(ASN1Object.fromByteArray(privateKeyInfoData)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inStr) throws IOException {
        return EAPTLSAuthenticator.createKey(PrivateKeyInfo.getInstance(new ASN1InputStream(inStr).readObject()));
    }

    public static AsymmetricKeyParameter createKey(PrivateKeyInfo keyInfo) throws IOException {
        AlgorithmIdentifier algId = keyInfo.getAlgorithmId();
        if (algId.getObjectId().equals(PKCSObjectIdentifiers.rsaEncryption)) {
            RSAPrivateKeyStructure keyStructure = new RSAPrivateKeyStructure((ASN1Sequence)keyInfo.getPrivateKey());
            return new RSAPrivateCrtKeyParameters(keyStructure.getModulus(), keyStructure.getPublicExponent(), keyStructure.getPrivateExponent(), keyStructure.getPrime1(), keyStructure.getPrime2(), keyStructure.getExponent1(), keyStructure.getExponent2(), keyStructure.getCoefficient());
        }
        if (algId.getObjectId().equals(PKCSObjectIdentifiers.dhKeyAgreement)) {
            DHParameter params = new DHParameter((ASN1Sequence)keyInfo.getAlgorithmId().getParameters());
            DERInteger derX = (DERInteger)keyInfo.getPrivateKey();
            BigInteger lVal = params.getL();
            int l = lVal == null ? 0 : lVal.intValue();
            DHParameters dhParams = new DHParameters(params.getP(), params.getG(), null, l);
            return new DHPrivateKeyParameters(derX.getValue(), dhParams);
        }
        if (algId.getObjectId().equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            ElGamalParameter params = new ElGamalParameter((ASN1Sequence)keyInfo.getAlgorithmId().getParameters());
            DERInteger derX = (DERInteger)keyInfo.getPrivateKey();
            return new ElGamalPrivateKeyParameters(derX.getValue(), new ElGamalParameters(params.getP(), params.getG()));
        }
        if (algId.getObjectId().equals(X9ObjectIdentifiers.id_dsa)) {
            DERInteger derX = (DERInteger)keyInfo.getPrivateKey();
            DEREncodable de = keyInfo.getAlgorithmId().getParameters();
            DSAParameters parameters = null;
            if (de != null) {
                DSAParameter params = DSAParameter.getInstance(de.getDERObject());
                parameters = new DSAParameters(params.getP(), params.getQ(), params.getG());
            }
            return new DSAPrivateKeyParameters(derX.getValue(), parameters);
        }
        if (algId.getObjectId().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            X962Parameters params = new X962Parameters((DERObject)keyInfo.getAlgorithmId().getParameters());
            ECDomainParameters dParams = null;
            if (params.isNamedCurve()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)params.getParameters();
                X9ECParameters ecP = X962NamedCurves.getByOID(oid);
                if (ecP == null && (ecP = SECNamedCurves.getByOID(oid)) == null && (ecP = NISTNamedCurves.getByOID(oid)) == null) {
                    ecP = TeleTrusTNamedCurves.getByOID(oid);
                }
                dParams = new ECDomainParameters(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
            } else {
                X9ECParameters ecP = new X9ECParameters((ASN1Sequence)params.getParameters());
                dParams = new ECDomainParameters(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
            }
            ECPrivateKeyStructure ec = new ECPrivateKeyStructure((ASN1Sequence)keyInfo.getPrivateKey());
            return new ECPrivateKeyParameters(ec.getKey(), dParams);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }

    protected boolean isCertificateRequired() {
        return true;
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    public void setKeyManagers(KeyManager[] keyManagers) {
        this.keyManagers = keyManagers;
    }

    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }

    public void setTrustManagers(TrustManager[] trustManagers) {
        this.trustManagers = trustManagers;
    }
}

