/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import com.datastax.oss.driver.api.core.servererrors.AlreadyExistsException;
import com.datastax.oss.driver.api.core.servererrors.SyntaxError;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultDriverConfigLoader;
import com.datastax.oss.driver.internal.core.ssl.DefaultSslEngineFactory;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import javax.inject.Named;
import org.opennms.newts.cassandra.CassandraSessionImpl;
import org.opennms.newts.cassandra.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaManager
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SchemaManager.class);
    private static final String KEYSPACE_PLACEHOLDER = "$KEYSPACE$";
    private static final String REPLICATION_FACTOR_PLACEHOLDER = "$REPLICATION_FACTOR$";
    public static final int DEFAULT_REPLICATION_FACTOR = 1;
    private String m_keyspace;
    private final CqlSession m_session;
    private int m_replicationFactor = 1;

    @Inject
    public SchemaManager(@Named(value="cassandra.datacenter") String datacenter, @Named(value="cassandra.keyspace") String keyspace, @Named(value="cassandra.hostname") String hostname, @Named(value="cassandra.port") int port, @Named(value="cassandra.username") String username, @Named(value="cassandra.password") String password, @Named(value="cassandra.ssl") boolean ssl, @Named(value="cassandra.driver-settings-file") String driverSettingsFile) {
        this.m_keyspace = keyspace;
        if (!Strings.isNullOrEmpty((String)driverSettingsFile)) {
            File settingsFile = new File(driverSettingsFile);
            LOG.info("Setting up session with settings file: {}", (Object)settingsFile);
            this.m_session = (CqlSession)((CqlSessionBuilder)CqlSession.builder().withConfigLoader(DefaultDriverConfigLoader.fromFile((File)settingsFile))).build();
            return;
        }
        ProgrammaticDriverConfigLoaderBuilder configBuilder = DriverConfigLoader.programmaticBuilder().startProfile("default");
        configBuilder.withStringList((DriverOption)DefaultDriverOption.CONTACT_POINTS, CassandraSessionImpl.toContactPoints(hostname, port));
        if (username != null && password != null) {
            LOG.info("Using username: {} and password: XXXXXXXX", (Object)username);
            configBuilder.withString((DriverOption)DefaultDriverOption.AUTH_PROVIDER_USER_NAME, username);
            configBuilder.withString((DriverOption)DefaultDriverOption.AUTH_PROVIDER_PASSWORD, password);
        }
        if (ssl) {
            configBuilder.withString((DriverOption)DefaultDriverOption.SSL_ENGINE_FACTORY_CLASS, DefaultSslEngineFactory.class.getCanonicalName());
        }
        this.m_session = (CqlSession)((CqlSessionBuilder)((CqlSessionBuilder)CqlSession.builder().withConfigLoader(configBuilder.build())).withLocalDatacenter(datacenter)).build();
    }

    public void create(Schema schema) throws IOException {
        this.create(schema, true);
    }

    public void create(Schema schema, boolean ifNotExists) throws IOException {
        this.create(schema, ifNotExists, false);
    }

    public void create(Schema schema, boolean ifNotExists, boolean printOnly) throws IOException {
        String line;
        Preconditions.checkNotNull((Object)schema, (Object)"schema argument");
        InputStream stream = (InputStream)Preconditions.checkNotNull((Object)schema.getInputStream(), (Object)"schema input stream");
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
        StringBuilder statement = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            String scrubbed = SchemaManager.scrub(line);
            statement.append(scrubbed);
            if (!scrubbed.endsWith(";")) continue;
            String queryString = statement.toString().replace(KEYSPACE_PLACEHOLDER, this.m_keyspace);
            queryString = queryString.replace(REPLICATION_FACTOR_PLACEHOLDER, Integer.toString(this.m_replicationFactor));
            if (printOnly) {
                System.err.println(queryString);
            } else {
                try {
                    this.m_session.execute(queryString);
                }
                catch (AlreadyExistsException e) {
                    if (ifNotExists) {
                        System.err.printf("%s; Nothing here to do%n", e.getLocalizedMessage());
                    }
                    throw e;
                }
                catch (SyntaxError e) {
                    System.out.printf("ERROR: %s (query: \"%s\").%n", e.getLocalizedMessage(), queryString);
                    throw e;
                }
            }
            statement = new StringBuilder();
        }
    }

    private static String scrub(String line) {
        return line.replace("\\s+", "").replace("//.*$", "").replace(";.*$", ";");
    }

    @Override
    public void close() {
        this.m_session.close();
    }

    public int getReplicationFactor() {
        return this.m_replicationFactor;
    }

    public void setReplicationFactor(int replicationFactor) {
        this.m_replicationFactor = replicationFactor;
    }
}

