/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.wsman;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.util.HashMap;
import org.opennms.core.wsman.Identity;
import org.opennms.core.wsman.WSManClient;
import org.opennms.core.wsman.WSManClientFactory;
import org.opennms.core.wsman.WSManEndpoint;
import org.opennms.core.wsman.exceptions.WSManException;
import org.opennms.netmgt.provision.DetectRequest;
import org.opennms.netmgt.provision.DetectResults;
import org.opennms.netmgt.provision.detector.wsman.WsmanEndpointUtils;
import org.opennms.netmgt.provision.support.DetectResultsImpl;
import org.opennms.netmgt.provision.support.SyncAbstractDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsManDetector
extends SyncAbstractDetector {
    public static final Logger LOG = LoggerFactory.getLogger(WsManDetector.class);
    private static final String PROTOCOL_NAME = "WS-Man";
    protected static final String UPDATE_ASSETS = "update-assests";
    protected static final String PRODUCT_VENDOR = "product-vendor";
    protected static final String PRODUCT_VERSION = "product-version";
    private WSManClientFactory m_factory;
    private boolean m_updateAssets = true;

    public WsManDetector() {
        super(PROTOCOL_NAME, 0);
    }

    public DetectResults detect(DetectRequest request) {
        try {
            WSManEndpoint endpoint = WsmanEndpointUtils.fromMap(request.getRuntimeAttributes());
            return this.isServiceDetected(request.getAddress(), endpoint);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isServiceDetected(InetAddress address) {
        throw new UnsupportedOperationException("WSManEndpoint is required.");
    }

    public DetectResults isServiceDetected(InetAddress address, WSManEndpoint endpoint) {
        WSManClient client = this.m_factory.getClient(endpoint);
        Identity identity = null;
        HashMap<String, String> attributes = new HashMap<String, String>();
        try {
            identity = client.identify();
            LOG.info("Identify succeeded for address {} with product vendor '{}' and product version '{}'.", new Object[]{address, identity.getProductVendor(), identity.getProductVersion()});
            attributes.put(UPDATE_ASSETS, Boolean.toString(this.m_updateAssets));
            attributes.put(PRODUCT_VENDOR, identity.getProductVendor());
            attributes.put(PRODUCT_VERSION, identity.getProductVersion());
        }
        catch (WSManException e) {
            LOG.info("Identify failed for address {} with endpoint {}.", new Object[]{address, endpoint, e});
        }
        return new DetectResultsImpl(identity != null, attributes);
    }

    public void setClientFactory(WSManClientFactory factory) {
        this.m_factory = factory;
    }

    public void setUpdateAssets(boolean updateAssets) {
        this.m_updateAssets = updateAssets;
    }

    public boolean getUpdateAssets() {
        return this.m_updateAssets;
    }

    protected void onInit() {
    }

    public void dispose() {
    }
}

