/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.newts.aggregate;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.opennms.newts.api.Element;
import org.opennms.newts.api.Measurement;
import org.opennms.newts.api.Results;

class Export
implements Iterable<Results.Row<Measurement>>,
Iterator<Results.Row<Measurement>> {
    private final Set<String> m_exports;
    private final Iterator<Results.Row<Measurement>> m_input;
    private Results.Row<Measurement> m_current;

    Export(Set<String> exports, Iterator<Results.Row<Measurement>> input) {
        this.m_exports = (Set)Preconditions.checkNotNull(exports, (Object)"exports argument");
        this.m_input = (Iterator)Preconditions.checkNotNull(input, (Object)"input argument");
        this.m_current = this.m_input.hasNext() ? this.m_input.next() : null;
    }

    @Override
    public boolean hasNext() {
        return this.m_current != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Results.Row<Measurement> next() {
        Results.Row row;
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Results.Row result = new Results.Row(this.m_current.getTimestamp(), this.m_current.getResource());
        for (String export : this.m_exports) {
            result.addElement((Element)this.getMeasurement(export));
        }
        try {
            row = result;
            this.m_current = this.m_input.hasNext() ? this.m_input.next() : null;
        }
        catch (Throwable throwable) {
            this.m_current = this.m_input.hasNext() ? this.m_input.next() : null;
            throw throwable;
        }
        return row;
    }

    private Measurement getMeasurement(String name) {
        Measurement measurement = (Measurement)this.m_current.getElement(name);
        return measurement != null ? measurement : this.getNan(name);
    }

    private Measurement getNan(String name) {
        return new Measurement(this.m_current.getTimestamp(), this.m_current.getResource(), name, Double.NaN);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Results.Row<Measurement>> iterator() {
        return this;
    }
}

