/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.collectd;

import com.google.common.base.Strings;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import java.util.List;
import org.opennms.netmgt.collectd.SnmpAttribute;
import org.opennms.netmgt.collectd.SnmpCollectionResource;
import org.opennms.netmgt.collectd.SnmpPropertyExtender;
import org.opennms.netmgt.collectd.ValueMappingAttributeType;
import org.opennms.netmgt.collection.api.AttributeGroup;
import org.opennms.netmgt.collection.api.AttributeGroupType;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.collection.api.CollectionAttribute;
import org.opennms.netmgt.config.datacollection.MibObjProperty;
import org.opennms.netmgt.snmp.SnmpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPropertyExtender
implements SnmpPropertyExtender {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpPropertyExtender.class);
    public static final String SOURCE_ATTRIBUTE = "source-attribute";
    public static final String TARGET_TYPE = "target-type";
    public static final String DEFAULT_VALUE = "default-value";
    public static final String JSON_PATH = "json-path";
    private static final Configuration JSON_PATH_CONFIG = Configuration.builder().options(new Option[]{Option.AS_PATH_LIST}).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SnmpAttribute getTargetAttribute(List<CollectionAttribute> sourceAttributes, SnmpCollectionResource targetResource, MibObjProperty property) {
        String sourceAttribute = property.getParameterValue(SOURCE_ATTRIBUTE);
        String targetType = property.getParameterValue(TARGET_TYPE, AttributeType.STRING.getName());
        AttributeType targetAttributeType = AttributeType.parse((String)targetType);
        String defaultValue = property.getParameterValue(DEFAULT_VALUE);
        String jsonPathExpression = property.getParameterValue(JSON_PATH);
        if (Strings.isNullOrEmpty((String)sourceAttribute)) {
            LOG.warn("Cannot execute the Json property extender because: missing parameter {}", (Object)SOURCE_ATTRIBUTE);
            return null;
        }
        if (Strings.isNullOrEmpty((String)jsonPathExpression)) {
            LOG.warn("Cannot execute the Json property extender because: missing parameter {}", (Object)JSON_PATH);
            return null;
        }
        if (targetAttributeType == null) {
            LOG.warn("Cannot execute the Json property extender because: error parsing target-type {}", (Object)targetType);
            return null;
        }
        for (AttributeGroup group : targetResource.getGroups()) {
            for (CollectionAttribute attribute : group.getAttributes()) {
                String result;
                JsonPath jsonPath;
                if (!sourceAttribute.equals(attribute.getName())) continue;
                try {
                    jsonPath = JsonPath.compile((String)jsonPathExpression, (Predicate[])new Predicate[0]);
                }
                catch (InvalidPathException e) {
                    LOG.warn("Cannot execute the Json property extender because of invalid Json path expression {}", (Object)targetType);
                    return null;
                }
                List entries = (List)JsonPath.using((Configuration)JSON_PATH_CONFIG).parse(attribute.getStringValue()).read(jsonPath);
                if (entries.isEmpty()) {
                    if (defaultValue == null) return null;
                    result = defaultValue;
                } else {
                    result = JsonPath.parse((String)attribute.getStringValue()).read(jsonPath).toString();
                }
                if (result == null) {
                    return null;
                }
                AttributeGroupType groupType = targetResource.getGroupType(property.getGroupName());
                return new SnmpAttribute(targetResource, new ValueMappingAttributeType(targetResource.getResourceType(), property, groupType, targetAttributeType), SnmpUtils.getValueFactory().getOctetString(result.getBytes()));
            }
        }
        return null;
    }
}

