/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.filters.impl.holtwinters;

import java.util.Arrays;
import org.apache.commons.math3.stat.descriptive.SummaryStatistics;
import org.opennms.netmgt.measurements.filters.impl.holtwinters.HoltWintersPointForecasterParams;
import org.opennms.netmgt.measurements.filters.impl.holtwinters.HoltWintersSeasonalityType;

public class HoltWintersOnlineComponents {
    private static final double MULTIPLICATIVE_IDENTITY = 1.0;
    private static final double ADDITIVE_IDENTITY = 0.0;
    private final HoltWintersPointForecasterParams params;
    private double level = 0.0;
    private double base = 0.0;
    private double[] seasonal;
    private SummaryStatistics overallSummaryStatistics = new SummaryStatistics();
    private SummaryStatistics[] seasonalSummaryStatistics;
    private double forecast = Double.NaN;

    public HoltWintersOnlineComponents(HoltWintersPointForecasterParams params) {
        this.params = params;
        this.initLevelFromParams(params);
        this.initBaseFromParams(params);
        this.initSeasonalsFromParams(params);
        this.initSeasonalStatistics(params);
    }

    public long getN() {
        return this.overallSummaryStatistics.getN();
    }

    public double getSeasonal(int seasonalIdx) {
        return this.seasonal[seasonalIdx];
    }

    public double[] getReverseHistorySeasonals() {
        int currentIdx = this.getCurrentSeasonalIndex();
        int m = this.params.getFrequency();
        double[] result = new double[m];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.getSeasonal((currentIdx + m - i - 1) % m);
        }
        return result;
    }

    public void setSeasonal(int seasonalIdx, double seasonalValue, double observed) {
        this.seasonal[seasonalIdx] = seasonalValue;
        this.seasonalSummaryStatistics[seasonalIdx].addValue(observed);
    }

    public void addValue(double observed) {
        this.overallSummaryStatistics.addValue(observed);
    }

    public double getSeasonalStandardDeviation(int seasonalIdx) {
        return this.seasonalSummaryStatistics[seasonalIdx].getStandardDeviation();
    }

    public int getCurrentSeasonalIndex() {
        return (int)(this.getN() % (long)this.params.getFrequency());
    }

    private void initLevelFromParams(HoltWintersPointForecasterParams params) {
        this.level = Double.isNaN(params.getInitLevelEstimate()) ? this.seasonalityIdentity() : params.getInitLevelEstimate();
    }

    private void initBaseFromParams(HoltWintersPointForecasterParams params) {
        this.base = Double.isNaN(params.getInitBaseEstimate()) ? this.seasonalityIdentity() : params.getInitBaseEstimate();
    }

    private void initSeasonalsFromParams(HoltWintersPointForecasterParams params) {
        int s = params.getInitSeasonalEstimates().length;
        if (s == 0) {
            this.fillSeasonalsWithIdentity();
        } else {
            if (s != params.getFrequency()) {
                throw new IllegalStateException(String.format("Invalid: initSeasonalEstimates array is not the same size (%d) as frequency (%d). Ensure only valid parameters are used.", s, params.getFrequency()));
            }
            this.seasonal = Arrays.copyOf(params.getInitSeasonalEstimates(), params.getFrequency());
        }
    }

    private void fillSeasonalsWithIdentity() {
        this.seasonal = new double[this.params.getFrequency()];
        Arrays.fill(this.seasonal, this.seasonalityIdentity());
    }

    private double seasonalityIdentity() {
        return this.params.getSeasonalityType() == HoltWintersSeasonalityType.MULTIPLICATIVE ? 1.0 : 0.0;
    }

    private void initSeasonalStatistics(HoltWintersPointForecasterParams params) {
        this.seasonalSummaryStatistics = new SummaryStatistics[params.getFrequency()];
        for (int i = 0; i < params.getFrequency(); ++i) {
            this.seasonalSummaryStatistics[i] = new SummaryStatistics();
            this.seasonalSummaryStatistics[i].addValue(this.seasonal[i]);
        }
    }

    public double getLevel() {
        return this.level;
    }

    public void setLevel(double level) {
        this.level = level;
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double base) {
        this.base = base;
    }

    public double getForecast() {
        return this.forecast;
    }

    public void setForecast(double forecast) {
        this.forecast = forecast;
    }
}

