/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.filters.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.RowSortedTable;
import com.google.common.collect.TreeBasedTable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.MapContext;
import org.opennms.core.utils.jexl.OnmsJexlEngine;
import org.opennms.netmgt.measurements.api.Filter;
import org.opennms.netmgt.measurements.api.FilterInfo;
import org.opennms.netmgt.measurements.api.FilterParam;

@FilterInfo(name="JEXL", description="Generic JEXL expression filter")
public class JEXL
implements Filter {
    @FilterParam(key="expression", required=true, displayName="Expression", description="JEXL expression.")
    private String m_expression;
    private final OnmsJexlEngine jexl = new OnmsJexlEngine();

    protected JEXL() {
        this.jexl.white(Math.class.getName());
        this.jexl.white(StrictMath.class.getName());
        this.jexl.white(TreeBasedTable.class.getName());
        HashMap functions = Maps.newHashMap();
        functions.put("math", Math.class);
        functions.put("strictmath", StrictMath.class);
        this.jexl.setFunctions((Map)functions);
    }

    public JEXL(String expression) {
        this();
        this.m_expression = expression;
    }

    public void filter(RowSortedTable<Long, String, Double> qrAsTable) throws Exception {
        HashMap jexlValues = Maps.newHashMap();
        jexlValues.put("table", qrAsTable);
        MapContext context = new MapContext((Map)jexlValues);
        Expression expression = this.jexl.createExpression(this.m_expression);
        expression.evaluate((JexlContext)context);
    }
}

