/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.address.impl;

import io.pkts.buffer.Buffer;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.address.TelURI;
import io.pkts.packet.sip.address.URI;
import io.pkts.packet.sip.address.impl.URIImpl;
import io.pkts.packet.sip.header.impl.ParametersSupport;
import io.pkts.packet.sip.impl.SipParser;
import java.util.Map;
import java.util.Set;

public class TelURIImpl
extends URIImpl
implements TelURI {
    private final boolean isGlobal;
    private final Buffer phoneNumber;
    private final Buffer headers;
    private final ParametersSupport paramsSupport;

    public TelURIImpl(boolean isGlobal, Buffer phoneNumber, Buffer headers, Buffer original) {
        super(original, SipParser.SCHEME_TEL);
        this.isGlobal = isGlobal;
        this.phoneNumber = phoneNumber;
        this.headers = headers.slice();
        this.paramsSupport = new ParametersSupport(headers);
    }

    @Override
    public URI clone() {
        return new TelURIImpl(this.isGlobal, this.phoneNumber, this.headers, this.getRawURI());
    }

    public TelURI.Builder copy() {
        return TelURI.withPhoneNumber(this.phoneNumber).withGlobal(this.isGlobal).withParameters(this.paramsSupport);
    }

    @Override
    public boolean isGlobal() {
        return this.isGlobal;
    }

    @Override
    public Buffer getPhoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public Buffer getParameter(Buffer name) throws SipParseException, IllegalArgumentException {
        return this.paramsSupport.getParameter(name);
    }

    @Override
    public Buffer getParameter(String name) throws SipParseException, IllegalArgumentException {
        return this.paramsSupport.getParameter(name);
    }

    @Override
    public Buffer toBuffer() {
        return this.getRawURI().slice();
    }

    public String toString() {
        return this.toBuffer().toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.headers == null ? 0 : this.headers.hashCode());
        result = 31 * result + (this.isGlobal ? 1231 : 1237);
        result = 31 * result + (this.phoneNumber == null ? 0 : this.phoneNumber.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TelURIImpl) {
            Set<Map.Entry<Buffer, Buffer>> entries;
            TelURIImpl other = (TelURIImpl)obj;
            if (this.isGlobal != other.isGlobal || !this.phoneNumber.toString().equals(other.getPhoneNumber().toString())) {
                return false;
            }
            if (this.paramsSupport != null && other.paramsSupport != null && (entries = this.paramsSupport.getAllParameters()) != null) {
                for (Map.Entry<Buffer, Buffer> entry : entries) {
                    Buffer key = entry.getKey();
                    Buffer value = entry.getValue();
                    Buffer bValue = other.getParameter(key);
                    if (!other.paramsSupport.hasParameter(key)) continue;
                    if (value == null ^ bValue == null) {
                        return false;
                    }
                    if (value.equalsIgnoreCase((Object)bValue)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

