/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.scv.immutables;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.opennms.integration.api.v1.scv.Credentials;

public class ImmutableCredentials
implements Credentials,
Serializable {
    static final long serialVersionUID = -1241293670886186178L;
    private final String username;
    private final String password;
    private final Map<String, String> attributes;

    public ImmutableCredentials(String username, String password) {
        this(username, password, Collections.emptyMap());
    }

    public ImmutableCredentials(String username, String password, Map<String, String> attributes) {
        this.username = username;
        this.password = password;
        this.attributes = attributes == null ? Collections.unmodifiableMap(Collections.emptyMap()) : Collections.unmodifiableMap(Objects.requireNonNull(attributes));
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public Set<String> getAttributeKeys() {
        return this.attributes.keySet();
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public int hashCode() {
        return Objects.hash(this.attributes, this.password, this.username);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Credentials other = (Credentials)obj;
        return Objects.equals(this.attributes, other.getAttributes()) && Objects.equals(this.password, other.getPassword()) && Objects.equals(this.username, other.getUsername());
    }

    public String toString() {
        return String.format("Credentials[username=%s,password=XXXXXX]", this.username);
    }
}

