/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.model.immutables;

import java.net.InetAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opennms.integration.api.v1.model.IpInterface;
import org.opennms.integration.api.v1.model.MetaData;
import org.opennms.integration.api.v1.model.Node;
import org.opennms.integration.api.v1.model.NodeAssetRecord;
import org.opennms.integration.api.v1.model.SnmpInterface;
import org.opennms.integration.api.v1.model.immutables.ImmutableIpInterface;
import org.opennms.integration.api.v1.model.immutables.ImmutableMetaData;
import org.opennms.integration.api.v1.model.immutables.ImmutableNodeAssetRecord;
import org.opennms.integration.api.v1.model.immutables.ImmutableSnmpInterface;
import org.opennms.integration.api.v1.util.ImmutableCollections;
import org.opennms.integration.api.v1.util.MutableCollections;

public final class ImmutableNode
implements Node {
    private final int id;
    private final String foreignSource;
    private final String foreignId;
    private final String label;
    private final String location;
    private final NodeAssetRecord assetRecord;
    private final List<IpInterface> ipInterfaces;
    private final List<SnmpInterface> snmpInterfaces;
    private final List<MetaData> metaData;
    private final List<String> categories;

    private ImmutableNode(Builder builder) {
        this.id = builder.id;
        this.foreignSource = builder.foreignSource;
        this.foreignId = builder.foreignId;
        this.label = builder.label;
        this.location = builder.location;
        this.assetRecord = ImmutableNodeAssetRecord.immutableCopy(builder.assetRecord);
        this.ipInterfaces = ImmutableCollections.with(ImmutableIpInterface::immutableCopy).newList(builder.ipInterfaces);
        this.snmpInterfaces = ImmutableCollections.with(ImmutableSnmpInterface::immutableCopy).newList(builder.snmpInterfaces);
        this.metaData = ImmutableCollections.with(ImmutableMetaData::immutableCopy).newList(builder.metaData);
        this.categories = ImmutableCollections.newListOfImmutableType(builder.categories);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(Node node) {
        return new Builder(node);
    }

    public static Node immutableCopy(Node node) {
        if (node == null || node instanceof ImmutableNode) {
            return node;
        }
        return ImmutableNode.newBuilderFrom(node).build();
    }

    public Integer getId() {
        return this.id;
    }

    public String getForeignSource() {
        return this.foreignSource;
    }

    public String getForeignId() {
        return this.foreignId;
    }

    public String getLabel() {
        return this.label;
    }

    public String getLocation() {
        return this.location;
    }

    public NodeAssetRecord getAssetRecord() {
        return this.assetRecord;
    }

    public List<IpInterface> getIpInterfaces() {
        return this.ipInterfaces;
    }

    public Optional<IpInterface> getInterfaceByIp(InetAddress ipAddr) {
        return this.ipInterfaces.stream().filter(intf -> Objects.equals(intf.getIpAddress(), ipAddr)).findFirst();
    }

    public List<SnmpInterface> getSnmpInterfaces() {
        return this.snmpInterfaces;
    }

    public List<MetaData> getMetaData() {
        return this.metaData;
    }

    public List<String> getCategories() {
        return this.categories;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableNode that = (ImmutableNode)o;
        return this.id == that.id && Objects.equals(this.foreignSource, that.foreignSource) && Objects.equals(this.foreignId, that.foreignId) && Objects.equals(this.label, that.label) && Objects.equals(this.location, that.location) && Objects.equals(this.assetRecord, that.assetRecord) && Objects.equals(this.ipInterfaces, that.ipInterfaces) && Objects.equals(this.snmpInterfaces, that.snmpInterfaces) && Objects.equals(this.metaData, that.metaData) && Objects.equals(this.categories, that.categories);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.foreignSource, this.foreignId, this.label, this.location, this.assetRecord, this.ipInterfaces, this.snmpInterfaces, this.metaData, this.categories);
    }

    public String toString() {
        return "ImmutableNode{id=" + this.id + ", foreignSource='" + this.foreignSource + "', foreignId='" + this.foreignId + "', label='" + this.label + "', location='" + this.location + "', assetRecord=" + this.assetRecord + ", ipInterfaces=" + this.ipInterfaces + ", snmpInterfaces=" + this.snmpInterfaces + ", metaData=" + this.metaData + ", categories=" + this.categories + "}";
    }

    public static final class Builder {
        private Integer id;
        private String foreignSource;
        private String foreignId;
        private String label;
        private String location;
        private NodeAssetRecord assetRecord;
        private List<IpInterface> ipInterfaces;
        private List<SnmpInterface> snmpInterfaces;
        private List<MetaData> metaData;
        private List<String> categories;

        private Builder() {
        }

        private Builder(Node node) {
            this.id = node.getId();
            this.foreignSource = node.getForeignSource();
            this.foreignId = node.getForeignId();
            this.label = node.getLabel();
            this.location = node.getLocation();
            this.assetRecord = node.getAssetRecord();
            this.ipInterfaces = MutableCollections.copyListFromNullable(node.getIpInterfaces(), LinkedList::new);
            this.snmpInterfaces = MutableCollections.copyListFromNullable(node.getSnmpInterfaces(), LinkedList::new);
            this.metaData = MutableCollections.copyListFromNullable(node.getMetaData(), LinkedList::new);
            this.categories = MutableCollections.copyListFromNullable(node.getCategories(), LinkedList::new);
        }

        public Builder setId(int id) {
            this.id = id;
            return this;
        }

        public Builder setForeignSource(String foreignSource) {
            this.foreignSource = foreignSource;
            return this;
        }

        public Builder setForeignId(String foreignId) {
            this.foreignId = foreignId;
            return this;
        }

        public Builder setLabel(String label) {
            this.label = label;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setAssetRecord(NodeAssetRecord assetRecord) {
            this.assetRecord = assetRecord;
            return this;
        }

        public Builder setIpInterfaces(List<IpInterface> ipInterfaces) {
            this.ipInterfaces = ipInterfaces;
            return this;
        }

        public Builder addIpInterface(IpInterface ipInterface) {
            if (this.ipInterfaces == null) {
                this.ipInterfaces = new LinkedList<IpInterface>();
            }
            this.ipInterfaces.add(ipInterface);
            return this;
        }

        public Builder setSnmpInterfaces(List<SnmpInterface> snmpInterfaces) {
            this.snmpInterfaces = snmpInterfaces;
            return this;
        }

        public Builder addSnmpInterface(SnmpInterface snmpInterface) {
            if (this.snmpInterfaces == null) {
                this.snmpInterfaces = new LinkedList<SnmpInterface>();
            }
            this.snmpInterfaces.add(snmpInterface);
            return this;
        }

        public Builder setMetaData(List<MetaData> metaData) {
            this.metaData = metaData;
            return this;
        }

        public Builder addMetaData(MetaData metaData) {
            if (this.metaData == null) {
                this.metaData = new LinkedList<MetaData>();
            }
            this.metaData.add(metaData);
            return this;
        }

        public Builder setCategories(List<String> categories) {
            this.categories = categories;
            return this;
        }

        public Builder addCategory(String category) {
            if (this.categories == null) {
                this.categories = new LinkedList<String>();
            }
            this.categories.add(category);
            return this;
        }

        public ImmutableNode build() {
            Objects.requireNonNull(this.id);
            return new ImmutableNode(this);
        }
    }
}

