/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.integration.api.v1.config.requisition.immutables;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.opennms.integration.api.v1.config.requisition.RequisitionMetaData;
import org.opennms.integration.api.v1.config.requisition.RequisitionMonitoredService;
import org.opennms.integration.api.v1.config.requisition.immutables.ImmutableRequisitionMetaData;
import org.opennms.integration.api.v1.util.ImmutableCollections;
import org.opennms.integration.api.v1.util.MutableCollections;

public final class ImmutableRequisitionMonitoredService
implements RequisitionMonitoredService {
    private final String name;
    private final List<RequisitionMetaData> metaData;

    private ImmutableRequisitionMonitoredService(String name, List<RequisitionMetaData> metaData) {
        this.name = name;
        this.metaData = ImmutableCollections.with(ImmutableRequisitionMetaData::immutableCopy).newList(metaData);
    }

    public static ImmutableRequisitionMonitoredService newInstance(String name, List<RequisitionMetaData> metaData) {
        return new ImmutableRequisitionMonitoredService(name, metaData);
    }

    public static RequisitionMonitoredService immutableCopy(RequisitionMonitoredService requisitionMonitoredService) {
        if (requisitionMonitoredService == null || requisitionMonitoredService instanceof ImmutableRequisitionMonitoredService) {
            return requisitionMonitoredService;
        }
        return ImmutableRequisitionMonitoredService.newInstance(requisitionMonitoredService.getName(), requisitionMonitoredService.getMetaData());
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilderFrom(RequisitionMonitoredService requisitionMonitoredService) {
        return new Builder(requisitionMonitoredService);
    }

    public String getName() {
        return this.name;
    }

    public List<RequisitionMetaData> getMetaData() {
        return this.metaData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableRequisitionMonitoredService that = (ImmutableRequisitionMonitoredService)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.metaData, that.metaData);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.metaData);
    }

    public String toString() {
        return "ImmutableRequisitionMonitoredService{name=" + this.name + ", metaData=" + this.metaData + "}";
    }

    public static final class Builder {
        private String name;
        private List<RequisitionMetaData> metaData;

        private Builder() {
        }

        private Builder(RequisitionMonitoredService requisitionMonitoredService) {
            this.name = requisitionMonitoredService.getName();
            this.metaData = MutableCollections.copyListFromNullable(requisitionMonitoredService.getMetaData(), LinkedList::new);
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setMetaData(List<RequisitionMetaData> metaData) {
            this.metaData = metaData;
            return this;
        }

        public Builder addMetaData(RequisitionMetaData metaData) {
            if (this.metaData == null) {
                this.metaData = new ArrayList<RequisitionMetaData>();
            }
            this.metaData.add(metaData);
            return this;
        }

        public ImmutableRequisitionMonitoredService build() {
            return ImmutableRequisitionMonitoredService.newInstance(this.name, this.metaData);
        }
    }
}

