/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.util;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.util.WorkerPool;
import org.snmp4j.util.WorkerTask;

public class ThreadPool
implements WorkerPool {
    private static final int DEFAULT_TASK_MANAGER_BUSY_TIMEOUT_MILLIS = 20;
    protected List<TaskManager> taskManagers;
    protected String name = "ThreadPool";
    protected volatile boolean stop = false;
    protected boolean respawnThreads = false;
    protected int taskManagersBusyTimeoutMillis = 20;

    protected ThreadPool() {
    }

    protected String getTaskManagerName(String prefix, int index) {
        return prefix + "." + index;
    }

    protected void setup(String name, int size) {
        this.name = name;
        this.taskManagers = new CopyOnWriteArrayList<TaskManager>();
        for (int i = 0; i < size; ++i) {
            TaskManager tm = new TaskManager(this.getTaskManagerName(name, i));
            this.taskManagers.add(tm);
            tm.start();
        }
    }

    public static ThreadPool create(String name, int size) {
        ThreadPool pool = new ThreadPool();
        pool.setup(name, size);
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(WorkerTask task) {
        while (true) {
            for (int i = 0; i < this.taskManagers.size(); ++i) {
                TaskManager tm = this.taskManagers.get(i);
                if (this.respawnThreads && !tm.isAlive()) {
                    tm = new TaskManager(this.getTaskManagerName(this.name, i));
                    this.taskManagers.set(i, tm);
                    tm.start();
                }
                if (!tm.isIdle()) continue;
                ThreadPool threadPool = this;
                synchronized (threadPool) {
                    if (tm.isIdle()) {
                        try {
                            tm.execute(task);
                            return;
                        }
                        catch (IllegalStateException illegalStateException) {
                            // empty catch block
                        }
                    }
                    continue;
                }
            }
            ThreadPool threadPool = this;
            synchronized (threadPool) {
                boolean waitForNotify = true;
                for (TaskManager tm : this.taskManagers) {
                    if (!tm.isIdle()) continue;
                    waitForNotify = false;
                    break;
                }
                if (waitForNotify) {
                    try {
                        this.wait(this.taskManagersBusyTimeoutMillis);
                    }
                    catch (InterruptedException ex) {
                        this.handleInterruptedExceptionOnExecute(ex, task);
                    }
                }
            }
        }
    }

    protected void handleInterruptedExceptionOnExecute(InterruptedException interruptedException, WorkerTask task) {
        if (SNMP4JSettings.isForwardRuntimeExceptions()) {
            throw new RuntimeException(interruptedException);
        }
    }

    @Override
    public boolean tryToExecute(WorkerTask task) {
        for (int i = 0; i < this.taskManagers.size(); ++i) {
            TaskManager tm = this.taskManagers.get(i);
            if (this.respawnThreads && !tm.isAlive()) {
                tm = new TaskManager(this.getTaskManagerName(this.name, i));
                tm.start();
            }
            if (!tm.isIdle()) continue;
            try {
                tm.execute(task);
                return true;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isRespawnThreads() {
        return this.respawnThreads;
    }

    public void setRespawnThreads(boolean respawnThreads) {
        this.respawnThreads = respawnThreads;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        List<TaskManager> tms;
        ThreadPool threadPool = this;
        synchronized (threadPool) {
            this.stop = true;
            tms = this.taskManagers;
        }
        for (TaskManager tm : tms) {
            tm.terminate();
            TaskManager taskManager = tm;
            synchronized (taskManager) {
                tm.notify();
            }
            try {
                tm.join();
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public void cancel() {
        this.stop = true;
        for (TaskManager tm : this.taskManagers) {
            tm.terminate();
            tm.interrupt();
        }
    }

    public void interrupt() {
        for (TaskManager tm : this.taskManagers) {
            tm.interrupt();
        }
    }

    @Override
    public boolean isIdle() {
        for (TaskManager tm : this.taskManagers) {
            if (tm.isIdle()) continue;
            return false;
        }
        return true;
    }

    public int getTaskManagersBusyTimeoutMillis() {
        return this.taskManagersBusyTimeoutMillis;
    }

    public void setTaskManagersBusyTimeoutMillis(int taskManagersBusyTimeoutMillis) {
        this.taskManagersBusyTimeoutMillis = taskManagersBusyTimeoutMillis;
    }

    class TaskManager
    extends Thread {
        private WorkerTask task;
        private volatile boolean run;

        public TaskManager(String name) {
            super(name);
            this.task = null;
            this.run = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!ThreadPool.this.stop && this.run) {
                Object object;
                if (this.task != null) {
                    object = this;
                    synchronized (object) {
                        this.task.run();
                        this.task = null;
                    }
                    object = ThreadPool.this;
                    synchronized (object) {
                        ThreadPool.this.notify();
                        continue;
                    }
                }
                object = this;
                synchronized (object) {
                    block13: {
                        try {
                            if (this.task != null) break block13;
                            this.wait();
                        }
                        catch (InterruptedException ex) {
                            this.run = ThreadPool.this.respawnThreads;
                            break;
                        }
                    }
                }
            }
        }

        public boolean isIdle() {
            return this.task == null && this.run;
        }

        public boolean isStopped() {
            return ThreadPool.this.stop;
        }

        public void terminate() {
            ThreadPool.this.stop = true;
            WorkerTask t = this.task;
            if (t != null) {
                t.terminate();
            }
        }

        public synchronized void execute(WorkerTask task) {
            if (this.task != null) {
                throw new IllegalStateException("TaskManager is not idle");
            }
            this.task = task;
            this.notify();
        }
    }
}

