/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.tracing.jaeger;

import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.ImportResource;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration
@Conditional(value={Condition.class})
@ImportResource(value={"/META-INF/opennms/applicationContext-tracer-jaeger.xml"})
public class ConditionalJaegerTracerContext {
    public static final String TRACER = "org.opennms.core.tracer";
    private static final String JEAGER_TRACER = "jaeger";
    private static final String GLOBAL_TRACER = "global";

    static class Condition
    implements ConfigurationCondition {
        Condition() {
        }

        public ConfigurationCondition.ConfigurationPhase getConfigurationPhase() {
            return ConfigurationCondition.ConfigurationPhase.PARSE_CONFIGURATION;
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String tracerProperty = System.getProperty(ConditionalJaegerTracerContext.TRACER, ConditionalJaegerTracerContext.GLOBAL_TRACER);
            boolean enabled = ConditionalJaegerTracerContext.JEAGER_TRACER.equals(tracerProperty);
            return enabled;
        }
    }
}

