/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.SessionFactory;
import org.hibernate.persister.entity.AbstractEntityPersister;

public class HibernateUtils {
    public static List<String> getHibernateTableColumnNames(SessionFactory factory, Class klass, boolean includeTablePrefix) {
        ArrayList<String> validColumnNames = new ArrayList<String>();
        AbstractEntityPersister aep = (AbstractEntityPersister)factory.getClassMetadata(klass);
        for (int propertyIndex = 0; propertyIndex < aep.getPropertyNames().length; ++propertyIndex) {
            String[] stringArray = aep.getPropertyColumnNames(propertyIndex);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String columnName = stringArray[i];
                if (columnName == null) continue;
                if (includeTablePrefix) {
                    validColumnNames.add(String.format("%s.%s", aep.getTableName().toLowerCase(), columnName.toLowerCase()));
                    continue;
                }
                validColumnNames.add(columnName.toLowerCase());
            }
        }
        for (String identifierColumn : aep.getIdentifierColumnNames()) {
            if (includeTablePrefix) {
                validColumnNames.add(String.format("%s.%s", aep.getTableName().toLowerCase(), identifierColumn.toLowerCase()));
                continue;
            }
            validColumnNames.add(identifierColumn.toLowerCase());
        }
        return validColumnNames;
    }

    public static void validateHibernateColumnNames(SessionFactory factory, List<Class> klasses, boolean includeTablePrefix, String ... columnNames) {
        ArrayList<String> validColumnNames = new ArrayList<String>();
        for (Class klass : klasses) {
            validColumnNames.addAll(HibernateUtils.getHibernateTableColumnNames(factory, klass, includeTablePrefix));
        }
        for (String columnName : columnNames) {
            if (columnName == null || validColumnNames.contains(columnName)) continue;
            throw new IllegalArgumentException(String.format("Invalid column name specified: %s", columnName));
        }
    }

    public static void validateHibernateColumnNames(SessionFactory factory, Class klass, boolean includeTablePrefix, String ... columnNames) {
        HibernateUtils.validateHibernateColumnNames(factory, Lists.newArrayList((Object[])new Class[]{klass}), includeTablePrefix, columnNames);
    }
}

