/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.math.BigInteger;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsEvent;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateCallback;

public class EventDaoHibernate
extends AbstractDaoHibernate<OnmsEvent, Long>
implements EventDao {
    public EventDaoHibernate() {
        super(OnmsEvent.class);
    }

    public int deletePreviousEventsForAlarm(Integer id, OnmsEvent e) throws DataAccessException {
        String hql = "delete from OnmsEvent where alarmid = ? and eventid != ?";
        Object[] values = new Object[]{id, e.getId()};
        return this.bulkDelete(hql, values);
    }

    public List<OnmsEvent> getEventsAfterDate(final List<String> ueiList, final Date date) {
        String hql = "From OnmsEvent e where e.eventUei in (:eventUei) and e.eventTime > :eventTime order by e.eventTime desc";
        return this.getHibernateTemplate().executeFind((HibernateCallback)new HibernateCallback<List<OnmsEvent>>(){

            public List<OnmsEvent> doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createQuery("From OnmsEvent e where e.eventUei in (:eventUei) and e.eventTime > :eventTime order by e.eventTime desc").setParameterList("eventUei", (Collection)ueiList).setParameter("eventTime", (Object)date).list();
            }
        });
    }

    public List<OnmsEvent> getEventsForEventParameters(final Map<String, String> eventParameters) {
        final StringBuffer hqlStringBuffer = new StringBuffer("From OnmsEvent e where ");
        for (int i = 0; i < eventParameters.size(); ++i) {
            if (i > 0) {
                hqlStringBuffer.append(" and ");
            }
            hqlStringBuffer.append("exists (select p.event from OnmsEventParameter p where e=p.event and p.name = :name" + i + " and p.value like :value" + i + ")");
        }
        return this.getHibernateTemplate().executeFind((HibernateCallback)new HibernateCallback<List<OnmsEvent>>(){

            public List<OnmsEvent> doInHibernate(Session session) throws HibernateException, SQLException {
                Query q = session.createQuery(hqlStringBuffer.toString());
                int i = 0;
                for (Map.Entry entry : eventParameters.entrySet()) {
                    q = q.setParameter("name" + i, entry.getKey()).setParameter("value" + i, entry.getValue());
                    ++i;
                }
                return q.list();
            }
        });
    }

    public long getNumEventsLastHours(int hours) {
        if (hours <= 0) {
            return 0L;
        }
        return (Long)this.getHibernateTemplate().execute(s -> {
            BigInteger result = (BigInteger)s.createSQLQuery("SELECT COUNT(*) FROM events WHERE eventtime >= NOW() - (:hours * INTERVAL '1 hour')").setParameter("hours", (Object)hours).uniqueResult();
            return result != null ? result.longValue() : 0L;
        });
    }
}

