/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.snmptrap;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.AbstractJaxbConfigDao;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapMappingGroup;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapNorthbounderConfig;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnmpTrapNorthbounderConfigDao
extends AbstractJaxbConfigDao<SnmpTrapNorthbounderConfig, SnmpTrapNorthbounderConfig> {
    public static final Logger LOG = LoggerFactory.getLogger(SnmpTrapNorthbounderConfigDao.class);
    private File m_configDirectory;

    public SnmpTrapNorthbounderConfigDao() {
        super(SnmpTrapNorthbounderConfig.class, "Config for SNMP Trap Northbounder");
    }

    protected SnmpTrapNorthbounderConfig translateConfig(SnmpTrapNorthbounderConfig config) {
        for (SnmpTrapSink sink : config.getSnmpTrapSinks()) {
            if (sink.getImportMappings() == null) continue;
            for (String link : sink.getImportMappings()) {
                File configFile = new File(this.getConfigDirectory(), link);
                if (!configFile.exists()) continue;
                try {
                    LOG.debug("Parsing file {}", (Object)configFile);
                    SnmpTrapMappingGroup group = (SnmpTrapMappingGroup)JaxbUtils.unmarshal(SnmpTrapMappingGroup.class, (File)configFile);
                    sink.addMappingGroup(group);
                }
                catch (Exception e) {
                    LOG.error("Can't parse {}", (Object)link, (Object)e);
                }
            }
        }
        return config;
    }

    private File getConfigDirectory() {
        if (this.m_configDirectory == null) {
            StringBuilder sb = new StringBuilder(ConfigFileConstants.getHome());
            sb.append(File.separator);
            sb.append("etc");
            sb.append(File.separator);
            this.m_configDirectory = new File(sb.toString());
        }
        return this.m_configDirectory;
    }

    public SnmpTrapNorthbounderConfig getConfig() {
        return (SnmpTrapNorthbounderConfig)this.getContainer().getObject();
    }

    public void reload() {
        this.getContainer().reload();
    }

    public void save() throws IOException {
        SnmpTrapNorthbounderConfig cfg = this.getConfig();
        cfg.getSnmpTrapSinks().forEach(s -> s.cleanMappingGroups());
        JaxbUtils.marshal((Object)cfg, (Writer)new FileWriter(this.getConfigResource().getFile()));
    }
}

