/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.snmptrap;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapSink;

@XmlRootElement(name="snmptrap-northbounder-config")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class SnmpTrapNorthbounderConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement(name="enabled", required=false, defaultValue="false")
    private Boolean m_enabled;
    @XmlElement(name="nagles-delay", required=false, defaultValue="1000")
    private Integer m_naglesDelay;
    @XmlElement(name="batch-size", required=false, defaultValue="100")
    private Integer m_batchSize;
    @XmlElement(name="queue-size", required=false, defaultValue="300000")
    private Integer m_queueSize;
    @XmlElement(name="snmp-trap-sink")
    private List<SnmpTrapSink> m_snmpTrapSinks = new ArrayList<SnmpTrapSink>();
    @XmlElement(name="uei", required=false)
    private List<String> m_ueis;

    public List<SnmpTrapSink> getSnmpTrapSinks() {
        return this.m_snmpTrapSinks;
    }

    public void setDestinations(List<SnmpTrapSink> snmpTrapSinks) {
        this.m_snmpTrapSinks = snmpTrapSinks;
    }

    public List<String> getUeis() {
        return this.m_ueis;
    }

    public void setUeis(List<String> ueis) {
        this.m_ueis = ueis;
    }

    public Integer getNaglesDelay() {
        return this.m_naglesDelay == null ? 1000 : this.m_naglesDelay;
    }

    public void setNaglesDelay(Integer naglesDelay) {
        this.m_naglesDelay = naglesDelay;
    }

    public Integer getBatchSize() {
        return this.m_batchSize == null ? 100 : this.m_batchSize;
    }

    public void setBatchSize(Integer batchSize) {
        this.m_batchSize = batchSize;
    }

    public Integer getQueueSize() {
        return this.m_queueSize == null ? 300000 : this.m_queueSize;
    }

    public void setQueueSize(Integer alarmQueueSize) {
        this.m_queueSize = alarmQueueSize;
    }

    public Boolean isEnabled() {
        return this.m_enabled == null ? Boolean.FALSE : this.m_enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.m_enabled = enabled;
    }

    public SnmpTrapSink getSnmpTrapSink(String trapSinkName) {
        for (SnmpTrapSink sink : this.m_snmpTrapSinks) {
            if (!sink.getName().equals(trapSinkName)) continue;
            return sink;
        }
        return null;
    }

    public void addSnmpTrapSink(SnmpTrapSink snmpTrapSink) {
        int index = -1;
        for (int i = 0; i < this.m_snmpTrapSinks.size(); ++i) {
            if (!this.m_snmpTrapSinks.get(i).getName().equals(snmpTrapSink.getName())) continue;
            index = i;
            break;
        }
        if (index > -1) {
            this.m_snmpTrapSinks.remove(index);
            this.m_snmpTrapSinks.add(index, snmpTrapSink);
        } else {
            this.m_snmpTrapSinks.add(snmpTrapSink);
        }
    }

    public boolean removeSnmpTrapSink(String trapSinkName) {
        int index = -1;
        for (int i = 0; i < this.m_snmpTrapSinks.size(); ++i) {
            if (!this.m_snmpTrapSinks.get(i).getName().equals(trapSinkName)) continue;
            index = i;
            break;
        }
        if (index > -1) {
            this.m_snmpTrapSinks.remove(index);
            return true;
        }
        return false;
    }
}

