/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.queue;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.listen.Listenable;
import org.apache.curator.framework.recipes.queue.ChildrenCache;
import org.apache.curator.framework.recipes.queue.DistributedQueue;
import org.apache.curator.framework.recipes.queue.ErrorMode;
import org.apache.curator.framework.recipes.queue.MultiItem;
import org.apache.curator.framework.recipes.queue.QueueBase;
import org.apache.curator.framework.recipes.queue.QueueConsumer;
import org.apache.curator.framework.recipes.queue.QueuePutListener;
import org.apache.curator.framework.recipes.queue.QueueSerializer;

public class DistributedPriorityQueue<T>
implements Closeable,
QueueBase<T> {
    private final DistributedQueue<T> queue;

    DistributedPriorityQueue(CuratorFramework client, QueueConsumer<T> consumer, QueueSerializer<T> serializer, String queuePath, ThreadFactory threadFactory, Executor executor, int minItemsBeforeRefresh, String lockPath, int maxItems, boolean putInBackground, int finalFlushMs) {
        Preconditions.checkArgument((minItemsBeforeRefresh >= 0 ? 1 : 0) != 0, (Object)"minItemsBeforeRefresh cannot be negative");
        this.queue = new DistributedQueue<T>(client, consumer, serializer, queuePath, threadFactory, executor, minItemsBeforeRefresh, true, lockPath, maxItems, putInBackground, finalFlushMs);
    }

    @Override
    public void start() throws Exception {
        this.queue.start();
    }

    @Override
    public void close() throws IOException {
        this.queue.close();
    }

    public void put(T item, int priority) throws Exception {
        this.put(item, priority, 0, null);
    }

    public boolean put(T item, int priority, int maxWait, TimeUnit unit) throws Exception {
        this.queue.checkState();
        String priorityHex = DistributedPriorityQueue.priorityToString(priority);
        return this.queue.internalPut(item, null, this.queue.makeItemPath() + priorityHex, maxWait, unit);
    }

    public void putMulti(MultiItem<T> items, int priority) throws Exception {
        this.putMulti(items, priority, 0, null);
    }

    public boolean putMulti(MultiItem<T> items, int priority, int maxWait, TimeUnit unit) throws Exception {
        this.queue.checkState();
        String priorityHex = DistributedPriorityQueue.priorityToString(priority);
        return this.queue.internalPut(null, items, this.queue.makeItemPath() + priorityHex, maxWait, unit);
    }

    @Override
    public void setErrorMode(ErrorMode newErrorMode) {
        this.queue.setErrorMode(newErrorMode);
    }

    @Override
    public boolean flushPuts(long waitTime, TimeUnit timeUnit) throws InterruptedException {
        return this.queue.flushPuts(waitTime, timeUnit);
    }

    @Override
    public Listenable<QueuePutListener<T>> getPutListenerContainer() {
        return this.queue.getPutListenerContainer();
    }

    @Override
    public int getLastMessageCount() {
        return this.queue.getLastMessageCount();
    }

    @VisibleForTesting
    ChildrenCache getCache() {
        return this.queue.getCache();
    }

    @VisibleForTesting
    static String priorityToString(int priority) {
        long l = (long)priority & 0xFFFFFFFFL;
        return String.format("%s%08X", priority >= 0 ? "1" : "0", l);
    }
}

