/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.framework.recipes.cache;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;

class TreeCacheIterator
implements Iterator<ChildData> {
    private final LinkedList<Current> stack = new LinkedList();
    private Current current;

    TreeCacheIterator(TreeCache.TreeNode root) {
        this.current = new Current((Iterator<TreeCache.TreeNode>)Iterators.forArray((Object[])new TreeCache.TreeNode[]{root}));
        this.stack.push(this.current);
    }

    @Override
    public boolean hasNext() {
        return this.current != null && TreeCache.isLive(this.current.node.childData);
    }

    @Override
    public ChildData next() {
        if (this.current == null) {
            throw new NoSuchElementException();
        }
        ChildData result = this.current.node.childData;
        do {
            this.setNext();
        } while (this.current != null && !TreeCache.isLive(this.current.node.childData));
        return result;
    }

    private void setNext() {
        block4: {
            if (this.current.node.children != null) {
                this.stack.push(this.current);
                this.current = new Current(this.current.node.children.values().iterator());
            } else {
                while (true) {
                    if (this.current.iterator.hasNext()) {
                        this.current.node = this.current.iterator.next();
                        break block4;
                    }
                    if (this.stack.size() <= 0) break;
                    this.current = this.stack.pop();
                }
                this.current = null;
            }
        }
    }

    private static class Current {
        final Iterator<TreeCache.TreeNode> iterator;
        TreeCache.TreeNode node;

        Current(Iterator<TreeCache.TreeNode> iterator) {
            this.iterator = iterator;
            this.node = iterator.next();
        }
    }
}

