/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.web;

import java.util.Map;
import org.opennms.core.web.HttpClientWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientWrapperConfigHelper {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientWrapperConfigHelper.class);

    public static void setUseSystemProxyIfDefined(HttpClientWrapper httpClientWrapper, Map<String, Object> keyedParameters) {
        if (HttpClientWrapperConfigHelper.getKeyedBoolean(keyedParameters, PARAMETER_KEYS.useSystemProxy.getKey(), false)) {
            httpClientWrapper.useSystemProxySettings();
            LOG.debug("setting useSystemProxySettings() on HttpClientWrapper");
        }
    }

    private static boolean getKeyedBoolean(Map<String, Object> map, String key, boolean defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        Object value = map.get(key);
        if (value == null) {
            return defaultValue;
        }
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return defaultValue;
    }

    public static enum PARAMETER_KEYS {
        useSystemProxy("use-system-proxy");

        private String key;

        private PARAMETER_KEYS(String key) {
            this.key = key;
        }

        String getKey() {
            return this.key;
        }
    }
}

