/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaData;
import org.hibernate.validator.internal.metadata.aggregated.BeanMetaDataImpl;
import org.hibernate.validator.internal.metadata.core.AnnotationProcessingOptions;
import org.hibernate.validator.internal.metadata.core.ConstraintHelper;
import org.hibernate.validator.internal.metadata.provider.AnnotationMetaDataProvider;
import org.hibernate.validator.internal.metadata.provider.MetaDataProvider;
import org.hibernate.validator.internal.metadata.raw.BeanConfiguration;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.ConcurrentReferenceHashMap;
import org.hibernate.validator.internal.util.Contracts;

public class BeanMetaDataManager {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    static final int DEFAULT_CONCURRENCY_LEVEL = 16;
    private final List<MetaDataProvider> metaDataProviders;
    private final ConstraintHelper constraintHelper;
    private final ConcurrentReferenceHashMap<Class<?>, BeanMetaData<?>> beanMetaDataCache;

    public BeanMetaDataManager(ConstraintHelper constraintHelper, MetaDataProvider ... metaDataProviders) {
        this(constraintHelper, Arrays.asList(metaDataProviders));
    }

    public BeanMetaDataManager(ConstraintHelper constraintHelper, List<MetaDataProvider> optionalMetaDataProviders) {
        this.constraintHelper = constraintHelper;
        this.metaDataProviders = CollectionHelper.newArrayList();
        this.metaDataProviders.addAll(optionalMetaDataProviders);
        this.beanMetaDataCache = new ConcurrentReferenceHashMap(16, 0.75f, 16, ConcurrentReferenceHashMap.ReferenceType.SOFT, ConcurrentReferenceHashMap.ReferenceType.SOFT, EnumSet.of(ConcurrentReferenceHashMap.Option.IDENTITY_COMPARISONS));
        AnnotationProcessingOptions annotationProcessingOptions = this.getAnnotationProcessingOptionsFromNonDefaultProviders();
        AnnotationMetaDataProvider defaultProvider = new AnnotationMetaDataProvider(constraintHelper, annotationProcessingOptions);
        this.metaDataProviders.add(defaultProvider);
    }

    public <T> BeanMetaData<T> getBeanMetaData(Class<T> beanClass) {
        BeanMetaData<?> cachedBeanMetaData;
        Contracts.assertNotNull(beanClass, "The bean type cannot be null.");
        BeanMetaData<?> beanMetaData = this.beanMetaDataCache.get(beanClass);
        if (beanMetaData == null && (cachedBeanMetaData = this.beanMetaDataCache.putIfAbsent(beanClass, beanMetaData = this.createBeanMetaData(beanClass))) != null) {
            beanMetaData = cachedBeanMetaData;
        }
        return beanMetaData;
    }

    public int numberOfCachedBeanMetaDataInstances() {
        return this.beanMetaDataCache.size();
    }

    private <T> BeanMetaDataImpl<T> createBeanMetaData(Class<T> clazz) {
        BeanMetaDataImpl.BeanMetaDataBuilder<T> builder = BeanMetaDataImpl.BeanMetaDataBuilder.getInstance(this.constraintHelper, clazz);
        for (MetaDataProvider provider : this.metaDataProviders) {
            for (BeanConfiguration<T> beanConfiguration : provider.getBeanConfigurationForHierarchy(clazz)) {
                builder.add(beanConfiguration);
            }
        }
        return builder.build();
    }

    private AnnotationProcessingOptions getAnnotationProcessingOptionsFromNonDefaultProviders() {
        AnnotationProcessingOptions options = new AnnotationProcessingOptions();
        for (MetaDataProvider metaDataProvider : this.metaDataProviders) {
            options.merge(metaDataProvider.getAnnotationProcessingOptions());
        }
        return options;
    }
}

