/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group;

import java.util.ArrayList;
import java.util.Map;
import java.util.OptionalLong;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.StaleMemberEpochException;
import org.apache.kafka.common.message.OffsetCommitRequestData;
import org.apache.kafka.common.message.OffsetCommitResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.coordinator.group.Group;
import org.apache.kafka.coordinator.group.GroupMetadataManager;
import org.apache.kafka.coordinator.group.OffsetAndMetadata;
import org.apache.kafka.coordinator.group.Record;
import org.apache.kafka.coordinator.group.RecordHelpers;
import org.apache.kafka.coordinator.group.generated.OffsetCommitKey;
import org.apache.kafka.coordinator.group.generated.OffsetCommitValue;
import org.apache.kafka.coordinator.group.generic.GenericGroup;
import org.apache.kafka.coordinator.group.generic.GenericGroupState;
import org.apache.kafka.coordinator.group.runtime.CoordinatorResult;
import org.apache.kafka.image.MetadataDelta;
import org.apache.kafka.image.MetadataImage;
import org.apache.kafka.timeline.SnapshotRegistry;
import org.apache.kafka.timeline.TimelineHashMap;
import org.slf4j.Logger;

public class OffsetMetadataManager {
    private final Logger log;
    private final SnapshotRegistry snapshotRegistry;
    private final Time time;
    private MetadataImage metadataImage;
    private final GroupMetadataManager groupMetadataManager;
    private final int offsetMetadataMaxSize;
    private final TimelineHashMap<String, TimelineHashMap<TopicPartition, OffsetAndMetadata>> offsetsByGroup;

    OffsetMetadataManager(SnapshotRegistry snapshotRegistry, LogContext logContext, Time time, MetadataImage metadataImage, GroupMetadataManager groupMetadataManager, int offsetMetadataMaxSize) {
        this.snapshotRegistry = snapshotRegistry;
        this.log = logContext.logger(OffsetMetadataManager.class);
        this.time = time;
        this.metadataImage = metadataImage;
        this.groupMetadataManager = groupMetadataManager;
        this.offsetMetadataMaxSize = offsetMetadataMaxSize;
        this.offsetsByGroup = new TimelineHashMap(snapshotRegistry, 0);
    }

    private Group validateOffsetCommit(RequestContext context, OffsetCommitRequestData request) throws ApiException {
        Group group;
        try {
            group = this.groupMetadataManager.group(request.groupId());
        }
        catch (GroupIdNotFoundException ex) {
            if (request.generationIdOrMemberEpoch() < 0) {
                group = this.groupMetadataManager.getOrMaybeCreateGenericGroup(request.groupId(), true);
            }
            if (context.header.apiVersion() >= 9) {
                throw ex;
            }
            throw Errors.ILLEGAL_GENERATION.exception();
        }
        try {
            group.validateOffsetCommit(request.memberId(), request.groupInstanceId(), request.generationIdOrMemberEpoch());
        }
        catch (StaleMemberEpochException ex) {
            if (context.header.apiVersion() >= 9) {
                throw ex;
            }
            throw Errors.UNSUPPORTED_VERSION.exception();
        }
        return group;
    }

    private static OptionalLong expireTimestampMs(long retentionTimeMs, long currentTimeMs) {
        return retentionTimeMs == -1L ? OptionalLong.empty() : OptionalLong.of(currentTimeMs + retentionTimeMs);
    }

    public CoordinatorResult<OffsetCommitResponseData, Record> commitOffset(RequestContext context, OffsetCommitRequestData request) throws ApiException {
        GenericGroup genericGroup;
        Group group = this.validateOffsetCommit(context, request);
        if (group.type() == Group.GroupType.GENERIC && ((genericGroup = (GenericGroup)group).isInState(GenericGroupState.STABLE) || genericGroup.isInState(GenericGroupState.PREPARING_REBALANCE))) {
            this.groupMetadataManager.rescheduleGenericGroupMemberHeartbeat(genericGroup, genericGroup.member(request.memberId()));
        }
        OffsetCommitResponseData response = new OffsetCommitResponseData();
        ArrayList records = new ArrayList();
        long currentTimeMs = this.time.milliseconds();
        OptionalLong expireTimestampMs = OffsetMetadataManager.expireTimestampMs(request.retentionTimeMs(), currentTimeMs);
        request.topics().forEach(topic -> {
            OffsetCommitResponseData.OffsetCommitResponseTopic topicResponse = new OffsetCommitResponseData.OffsetCommitResponseTopic().setName(topic.name());
            response.topics().add(topicResponse);
            topic.partitions().forEach(partition -> {
                if (partition.committedMetadata() != null && partition.committedMetadata().length() > this.offsetMetadataMaxSize) {
                    topicResponse.partitions().add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(partition.partitionIndex()).setErrorCode(Errors.OFFSET_METADATA_TOO_LARGE.code()));
                } else {
                    this.log.debug("[GroupId {}] Committing offsets {} for partition {}-{} from member {} with leader epoch {}.", new Object[]{request.groupId(), partition.committedOffset(), topic.name(), partition.partitionIndex(), request.memberId(), partition.committedLeaderEpoch()});
                    topicResponse.partitions().add(new OffsetCommitResponseData.OffsetCommitResponsePartition().setPartitionIndex(partition.partitionIndex()).setErrorCode(Errors.NONE.code()));
                    OffsetAndMetadata offsetAndMetadata = OffsetAndMetadata.fromRequest(partition, currentTimeMs, expireTimestampMs);
                    records.add(RecordHelpers.newOffsetCommitRecord(request.groupId(), topic.name(), partition.partitionIndex(), offsetAndMetadata, this.metadataImage.features().metadataVersion()));
                }
            });
        });
        return new CoordinatorResult<OffsetCommitResponseData, Record>(records, response);
    }

    public void replay(OffsetCommitKey key, OffsetCommitValue value) {
        String groupId = key.group();
        TopicPartition tp = new TopicPartition(key.topic(), key.partition());
        if (value != null) {
            try {
                this.groupMetadataManager.group(groupId);
            }
            catch (GroupIdNotFoundException ex) {
                this.groupMetadataManager.getOrMaybeCreateGenericGroup(groupId, true);
            }
            OffsetAndMetadata offsetAndMetadata = OffsetAndMetadata.fromRecord(value);
            TimelineHashMap offsets = (TimelineHashMap)this.offsetsByGroup.get((Object)groupId);
            if (offsets == null) {
                offsets = new TimelineHashMap(this.snapshotRegistry, 0);
                this.offsetsByGroup.put((Object)groupId, (Object)offsets);
            }
            offsets.put((Object)tp, (Object)offsetAndMetadata);
        } else {
            TimelineHashMap offsets = (TimelineHashMap)this.offsetsByGroup.get((Object)groupId);
            if (offsets != null) {
                offsets.remove((Object)tp);
                if (offsets.isEmpty()) {
                    this.offsetsByGroup.remove((Object)groupId);
                }
            }
        }
    }

    public void onNewMetadataImage(MetadataImage newImage, MetadataDelta delta) {
        this.metadataImage = newImage;
    }

    OffsetAndMetadata offset(String groupId, TopicPartition tp) {
        Map offsets = (Map)this.offsetsByGroup.get((Object)groupId);
        if (offsets == null) {
            return null;
        }
        return (OffsetAndMetadata)offsets.get(tp);
    }

    public static class Builder {
        private LogContext logContext = null;
        private SnapshotRegistry snapshotRegistry = null;
        private Time time = null;
        private GroupMetadataManager groupMetadataManager = null;
        private int offsetMetadataMaxSize = 4096;
        private MetadataImage metadataImage = null;

        Builder withLogContext(LogContext logContext) {
            this.logContext = logContext;
            return this;
        }

        Builder withSnapshotRegistry(SnapshotRegistry snapshotRegistry) {
            this.snapshotRegistry = snapshotRegistry;
            return this;
        }

        Builder withTime(Time time) {
            this.time = time;
            return this;
        }

        Builder withGroupMetadataManager(GroupMetadataManager groupMetadataManager) {
            this.groupMetadataManager = groupMetadataManager;
            return this;
        }

        Builder withOffsetMetadataMaxSize(int offsetMetadataMaxSize) {
            this.offsetMetadataMaxSize = offsetMetadataMaxSize;
            return this;
        }

        Builder withMetadataImage(MetadataImage metadataImage) {
            this.metadataImage = metadataImage;
            return this;
        }

        public OffsetMetadataManager build() {
            if (this.logContext == null) {
                this.logContext = new LogContext();
            }
            if (this.snapshotRegistry == null) {
                this.snapshotRegistry = new SnapshotRegistry(this.logContext);
            }
            if (this.metadataImage == null) {
                this.metadataImage = MetadataImage.EMPTY;
            }
            if (this.time == null) {
                this.time = Time.SYSTEM;
            }
            if (this.groupMetadataManager == null) {
                throw new IllegalArgumentException("GroupMetadataManager cannot be null");
            }
            return new OffsetMetadataManager(this.snapshotRegistry, this.logContext, this.time, this.metadataImage, this.groupMetadataManager, this.offsetMetadataMaxSize);
        }
    }
}

