/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.io.UnsupportedEncodingException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.http.AuthInfo;
import org.sblim.wbem.http.BASE64Encoder;
import org.sblim.wbem.http.Challenge;
import org.sblim.wbem.http.HttpClient;
import org.sblim.wbem.http.HttpHeader;
import org.sblim.wbem.util.SessionProperties;

public class WwwAuthInfo
extends AuthInfo {
    public String toString() {
        StringBuffer result = new StringBuffer();
        String _nc = Long.toHexString(this.iNc);
        if (this.iScheme.equalsIgnoreCase("Digest")) {
            if (this.iRealm == null) {
                try {
                    MessageDigest messageDigest = null;
                    messageDigest = MessageDigest.getInstance("MD5");
                    messageDigest.update(WwwAuthInfo.getBytes(this.iCredentials != null && this.iCredentials.getUserName() != null ? String.valueOf(this.iCredentials.getPassword()) : "null", "UTF-8"));
                    String pass = HttpClient.convertToHexString(messageDigest.digest());
                    return "Digest username=" + (this.iCredentials != null && this.iCredentials.getUserName() != null ? this.iCredentials.getUserName() : "null") + ", response=" + pass;
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
            }
            result.append(this.iScheme);
            result.append(" username=\"");
            result.append(this.iCredentials != null && this.iCredentials.getUserName() != null ? this.iCredentials.getUserName() : "null");
            result.append("\"");
            if (this.iRealm != null) {
                result.append(", realm=\"");
                result.append(this.iRealm);
                result.append("\"");
            }
            if (this.iNonce != null) {
                result.append(", nonce=\"");
                result.append(this.iNonce);
                result.append("\"");
            }
            result.append(", uri=\"");
            result.append(this.iUri);
            result.append("\", response=\"");
            result.append(this.iResponse);
            result.append("\"");
            if (this.iCnonce != null) {
                result.append(", cnonce=\"");
                result.append(this.iCnonce);
                result.append("\"");
            }
            if (this.iOpaque != null) {
                result.append(", opaque=\"");
                result.append(this.iOpaque);
                result.append("\"");
            }
            if (this.iQop != null) {
                result.append(", qop=");
                result.append(this.iQop);
            }
            if (this.iNc > -1L) {
                result.append(", nc=");
                result.append("00000000".substring(_nc.length()));
                result.append(_nc);
            }
        } else if (this.iScheme.equalsIgnoreCase("Basic")) {
            result.append("Basic ");
            StringBuffer tmp = new StringBuffer();
            tmp.append(this.iCredentials != null && this.iCredentials.getUserName() != null ? this.iCredentials.getUserName() : "null");
            tmp.append(':');
            tmp.append(this.iCredentials != null && this.iCredentials.getPassword() != null ? String.valueOf(this.iCredentials.getPassword()) : "null");
            result.append(BASE64Encoder.encode(WwwAuthInfo.getBytes(tmp.toString(), "UTF-8")));
        }
        return result.toString();
    }

    public static String[] split(String line) {
        int end;
        Vector<String> elem = new Vector<String>();
        int start = 0;
        while ((end = line.indexOf(44)) > -1) {
            elem.add(line.substring(start, end));
            start = end + 1;
        }
        if (end < line.length()) {
            elem.add(line.substring(start));
        }
        String[] result = new String[elem.size()];
        elem.toArray(result);
        return result;
    }

    private static byte[] getBytes(String str, String encoding) {
        byte[] bytes;
        try {
            bytes = str.getBytes(encoding);
        }
        catch (UnsupportedEncodingException e) {
            bytes = str.getBytes();
        }
        return bytes;
    }

    public void updateAuthenticationInfo(Challenge challenge, String authenticate, URI url, String requestMethod) throws NoSuchAlgorithmException {
        this.setURI(url.getPath());
        HttpHeader params = challenge.getParams();
        this.iScheme = challenge.getScheme();
        if (!this.iScheme.equalsIgnoreCase("Digest")) {
            return;
        }
        this.iRealm = params.getField("realm");
        String algorithm = params.getField("algorithm");
        String opaque = params.getField("opaque");
        String nonce = params.getField("nonce");
        String qop = params.getField("qop");
        this.iAlgorithm = algorithm != null ? algorithm : this.iAlgorithm;
        this.iOpaque = opaque != null ? opaque : this.iOpaque;
        this.iNonce = nonce != null ? nonce : this.iNonce;
        this.iQop = qop != null ? qop : this.iQop;
        MessageDigest messageDigest = null;
        messageDigest = MessageDigest.getInstance("MD5");
        if (qop != null || "md5-sess".equalsIgnoreCase(algorithm)) {
            long time = System.currentTimeMillis();
            byte[] b = new byte[]{(byte)(time >> 0 & 0xFFL), (byte)(time >> 8 & 0xFFL), (byte)(time >> 16 & 0xFFL), (byte)(time >> 24 & 0xFFL), (byte)(time >> 32 & 0xFFL), (byte)(time >> 40 & 0xFFL), (byte)(time >> 48 & 0xFFL), (byte)(time >> 56 & 0xFFL)};
            messageDigest.reset();
            messageDigest.update(b);
            this.iCnonce = HttpClient.convertToHexString(messageDigest.digest());
        }
        if (qop != null) {
            String[] list_qop = WwwAuthInfo.split(qop);
            for (int i = 0; i < list_qop.length; ++i) {
                if (list_qop[i].equalsIgnoreCase("auth-int")) {
                    qop = "auth-int";
                    break;
                }
                if (!list_qop[i].equalsIgnoreCase("auth")) continue;
                qop = "auth";
            }
            if (qop != null) {
                this.setQop(qop);
            }
        }
        String nc1 = params.getField("nc");
        long challengeNc = 1L;
        if (nc1 != null) {
            block15: {
                try {
                    challengeNc = Long.parseLong(nc1, 16);
                }
                catch (Exception e) {
                    Logger logger = SessionProperties.getGlobalProperties().getLogger();
                    if (!logger.isLoggable(Level.WARNING)) break block15;
                    logger.log(Level.WARNING, "exception while parsing challenge NC", e);
                }
            }
            if (this.getNc() == challengeNc) {
                this.setNc(++challengeNc);
            }
        } else {
            challengeNc = 1L;
            this.setNc(1L);
        }
        messageDigest.reset();
        PasswordAuthentication credentials1 = this.getCredentials();
        this.iA1 = credentials1.getUserName() + ":" + this.getRealm() + ":" + String.valueOf(credentials1.getPassword());
        messageDigest.update(WwwAuthInfo.getBytes(this.iA1, "UTF-8"));
        if ("md5-sess".equalsIgnoreCase(algorithm)) {
            messageDigest.update(WwwAuthInfo.getBytes(":" + this.getNonce() + ":" + this.getCnonce(), "UTF-8"));
        }
        byte[] digest1 = messageDigest.digest();
        String sessionKey = HttpClient.convertToHexString(digest1);
        String method = requestMethod;
        String A2 = method + ":" + this.getURI();
        if ("auth-int".equalsIgnoreCase(qop)) {
            messageDigest.reset();
            messageDigest.update(new byte[0]);
            A2 = A2 + ":" + HttpClient.convertToHexString(messageDigest.digest());
        }
        messageDigest.reset();
        messageDigest.update(WwwAuthInfo.getBytes(A2, "UTF-8"));
        A2 = HttpClient.convertToHexString(messageDigest.digest());
        messageDigest.reset();
        if (qop == null) {
            messageDigest.update(WwwAuthInfo.getBytes(sessionKey + ":" + nonce + ":" + A2, "UTF-8"));
        } else {
            String _nc = Long.toHexString(challengeNc);
            messageDigest.update(WwwAuthInfo.getBytes(sessionKey + ":" + nonce + ":" + "00000000".substring(_nc.length()) + _nc + ":" + this.getCnonce() + ":" + qop + ":" + A2, "UTF-8"));
        }
        this.iResponse = HttpClient.convertToHexString(messageDigest.digest());
    }

    public String getHeaderFieldName() {
        return "Authorization";
    }

    public boolean isSentOnFirstRequest() {
        return false;
    }

    public boolean isKeptAlive() {
        return true;
    }
}

