/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMObject;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMQualifier;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.util.Utils;

public class CIMInstance
extends CIMObject
implements Serializable {
    private static final long serialVersionUID = -1992307623410992121L;
    protected String iAlias;

    public CIMInstance() {
        this.iObjectPath = new CIMObjectPath();
    }

    public CIMInstance(CIMObjectPath pObjectPath) {
        if (pObjectPath == null) {
            this.iObjectPath = new CIMObjectPath();
        } else {
            this.iObjectPath = (CIMObjectPath)pObjectPath.clone();
            this.iName = this.iObjectPath.getObjectName();
            if (this.iName == null) {
                throw new IllegalArgumentException("null class name");
            }
            Vector keys = pObjectPath.getKeys();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                this.addProperty((CIMProperty)iter.next());
            }
        }
    }

    public Object clone() {
        CIMInstance that = new CIMInstance();
        that.iName = this.iName;
        that.iAlias = this.iAlias;
        that.iObjectPath = (CIMObjectPath)this.iObjectPath.clone();
        Iterator iter = this.iQualifiers.iterator();
        while (iter.hasNext()) {
            CIMQualifier qual = (CIMQualifier)iter.next();
            that.iQualifiers.add(qual.clone());
        }
        iter = this.iAllProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty prop = (CIMProperty)iter.next();
            that.addProperty((CIMProperty)prop.clone());
        }
        return that;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMInstance)) {
            return false;
        }
        CIMInstance that = (CIMInstance)o;
        if (!this.iQualifiers.equals(that.iQualifiers) || !this.iAllProperties.equals(that.iAllProperties)) {
            return false;
        }
        if (!(this.iAlias != null ? this.iAlias.equalsIgnoreCase(that.iAlias) : that.iAlias == null)) {
            return false;
        }
        return this.iName.equalsIgnoreCase(that.iName);
    }

    public int hashCode() {
        return this.iName.hashCode() + this.iQualifiers.hashCode() + this.iAllProperties.hashCode() + (this.iAlias != null ? this.iAlias.hashCode() : 0);
    }

    public String getAlias() {
        return this.iAlias;
    }

    public String getClassName() {
        return this.iName;
    }

    public Vector getKeyValuePairs() {
        return this.getKeys();
    }

    public String getName() {
        return this.iName;
    }

    public CIMObjectPath getObjectPath() {
        this.iObjectPath.setKeys(this.getKeyValuePairs());
        return this.iObjectPath;
    }

    public void setObjectPath(CIMObjectPath pObjectPath) {
        if (pObjectPath == null) {
            throw new IllegalArgumentException("null objectpath argument");
        }
        this.iName = pObjectPath.getObjectName();
        this.iObjectPath.setObjectName(this.iName);
        this.iObjectPath.setHost(pObjectPath.getHost());
        this.iObjectPath.setNameSpace(pObjectPath.getNameSpace());
        Vector keys = pObjectPath.getKeys();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            CIMProperty key = (CIMProperty)iter.next();
            CIMProperty localProp = this.getProperty(key);
            if (localProp == null) {
                this.addProperty(key);
                continue;
            }
            localProp.addQualifier(new CIMQualifier("Key"));
            if (localProp.getType().getType() != 14) continue;
            this.setProperty(key.getName(), key.getValue());
        }
    }

    public void setAlias(String pAliasName) {
        this.iAlias = pAliasName;
    }

    public void setClassName(String pClassname) {
        if (pClassname == null) {
            throw new IllegalArgumentException("null classname argument");
        }
        this.iObjectPath.setObjectName(pClassname);
        this.iName = pClassname;
    }

    public void setName(String pName) {
        if (pName == null) {
            throw new IllegalArgumentException("null name argument");
        }
        this.iName = pName;
        this.iObjectPath.setObjectName(pName);
    }

    public String toMOF() {
        StringBuffer buffer = new StringBuffer();
        if (this.iQualifiers.size() > 0) {
            buffer.append("\n\t");
            buffer.append(CIMInstance.vectorToMOFString(this.iQualifiers, false, 1));
            buffer.append("\n");
        }
        buffer.append("instance of ");
        buffer.append(this.getClassName());
        buffer.append(" ");
        if (this.iAlias != null && this.iAlias.length() > 0) {
            buffer.append("as space");
            buffer.append(this.iAlias);
            buffer.append(" ");
        }
        buffer.append("{\n");
        if (this.iAllProperties.size() > 0) {
            buffer.append(CIMInstance.vectorToMOFString(this.iAllProperties, true, 0, 0, false));
            buffer.append(" ");
        }
        buffer.append("};");
        return buffer.toString();
    }

    public String toString() {
        return this.toMOF();
    }

    public void updateProperty(CIMProperty pProperty) {
        if (pProperty == null) {
            throw new IllegalArgumentException("null property argument");
        }
        Iterator iter = this.iAllProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty prop = (CIMProperty)iter.next();
            if (!prop.getName().equals(pProperty.getName())) continue;
            prop.setValue(pProperty.getValue());
            Iterator iter2 = pProperty.getQualifiers().iterator();
            while (iter2.hasNext()) {
                CIMQualifier qual = (CIMQualifier)iter2.next();
                prop.addQualifier(qual);
            }
            prop.setOverridingProperty(pProperty.getOverridingProperty());
            prop.setOriginClass(pProperty.getOriginClass());
            return;
        }
        this.addProperty(pProperty);
    }

    public boolean updatePropertyValue(CIMProperty pProperty) {
        if (pProperty == null) {
            throw new IllegalArgumentException("null property argument");
        }
        Iterator iter = this.iAllProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty prop = (CIMProperty)iter.next();
            if (!prop.getName().equals(pProperty.getName())) continue;
            prop.setValue(pProperty.getValue());
            return true;
        }
        Utils.addSorted(this.iAllProperties, pProperty);
        return false;
    }

    public void updatePropertyValue(Vector pProperties) {
        if (pProperties == null) {
            throw new IllegalArgumentException("null values argument");
        }
        Iterator iter = pProperties.iterator();
        if (iter.hasNext()) {
            CIMProperty property = (CIMProperty)iter.next();
            this.updatePropertyValue(property);
            return;
        }
    }

    public static void main(String[] args) {
        CIMObjectPath op = new CIMObjectPath("MyTestClass");
        CIMProperty p1 = new CIMProperty("KeyedProperty");
        p1.addQualifier(new CIMQualifier("Key"));
        op.addKey(p1);
        CIMProperty p2 = new CIMProperty("KeyedProperty");
        p2.setValue(new CIMValue("Value1", CIMDataType.getPredefinedType(8)));
        p2.addQualifier(new CIMQualifier("Key"));
        p2.addQualifier(new CIMQualifier("Overridable"));
        System.out.println("CIMInstance(ObjectPath)");
        CIMInstance instance = new CIMInstance(op);
        System.out.println(instance);
        System.out.println("updateProperty()");
        instance.updateProperty(p2);
        System.out.println(instance);
        System.out.println("setName()");
        instance.setName("NewClassName");
        System.out.println(instance);
        System.out.println("getObjectPath()");
        System.out.println(instance.getObjectPath());
        System.out.println("hashCode()");
        System.out.println(instance.hashCode());
        System.out.println("clone()");
        CIMInstance instance2 = (CIMInstance)instance.clone();
        System.out.println(instance2);
        System.out.println("instance.equals(instance2)");
        System.out.println(instance2.equals(instance));
        System.out.println("instance.addQualifier(new CIMQualifier(\"Association\"))");
        instance2.addQualifier(new CIMQualifier("Association"));
        System.out.println("instance.equals(instance2)");
        System.out.println(instance2.equals(instance));
    }
}

