/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.support.hops;

import java.util.ArrayList;
import java.util.Set;
import org.opennms.features.topology.api.GraphContainer;
import org.opennms.features.topology.api.support.hops.VertexHopCriteria;
import org.opennms.features.topology.api.support.hops.WrappedVertexHopCriteria;
import org.opennms.features.topology.api.topo.CollapsibleCriteria;
import org.opennms.features.topology.api.topo.Criteria;

public interface CriteriaUtils {
    public static WrappedVertexHopCriteria getWrappedVertexHopCriteria(GraphContainer graphContainer) {
        Set<VertexHopCriteria> vertexHopCriterias = Criteria.getCriteriaForGraphContainer(graphContainer, VertexHopCriteria.class);
        return new WrappedVertexHopCriteria(vertexHopCriterias);
    }

    public static CollapsibleCriteria[] getCollapsedCriteriaForContainer(GraphContainer graphContainer) {
        return CriteriaUtils.getCollapsedCriteria(graphContainer.getCriteria());
    }

    public static CollapsibleCriteria[] getCollapsedCriteria(Criteria[] criteria) {
        return CriteriaUtils.getCollapsibleCriteria(criteria, true);
    }

    public static CollapsibleCriteria[] getCollapsibleCriteriaForContainer(GraphContainer graphContainer) {
        return CriteriaUtils.getCollapsibleCriteria(graphContainer.getCriteria());
    }

    public static CollapsibleCriteria[] getCollapsibleCriteria(Criteria[] criteria) {
        return CriteriaUtils.getCollapsibleCriteria(criteria, false);
    }

    public static CollapsibleCriteria[] getCollapsibleCriteria(Criteria[] criteria, boolean onlyCollapsed) {
        ArrayList<CollapsibleCriteria> retval = new ArrayList<CollapsibleCriteria>();
        if (criteria != null) {
            for (Criteria criterium : criteria) {
                try {
                    CollapsibleCriteria hopCriteria = (CollapsibleCriteria)((Object)criterium);
                    if (onlyCollapsed) {
                        if (!hopCriteria.isCollapsed()) continue;
                        retval.add(hopCriteria);
                        continue;
                    }
                    retval.add(hopCriteria);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
        return retval.toArray(new CollapsibleCriteria[0]);
    }
}

