/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.topology.api.support;

import com.vaadin.server.ExternalResource;
import com.vaadin.server.Resource;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Component;
import com.vaadin.ui.Embedded;
import com.vaadin.ui.Window;
import com.vaadin.v7.ui.VerticalLayout;
import java.net.URL;

public class InfoWindow
extends Window {
    private static final long serialVersionUID = -510407825043696244L;
    private static final double sizePercentage = 0.8;
    private static final int widthCushion = 50;
    private static final int heightCushion = 110;
    private Embedded infoBrowser = null;

    public InfoWindow(URL embeddedURL, LabelCreator labelCreator) {
        this.infoBrowser = new Embedded("", (Resource)new ExternalResource(embeddedURL));
        String label = labelCreator == null ? "" : labelCreator.getLabel();
        this.setCaption(label);
        this.setResizable(false);
        this.setModal(true);
        VerticalLayout layout = new VerticalLayout();
        layout.addComponent((Component)this.infoBrowser);
        this.setContent((Component)layout);
    }

    public void attach() {
        super.attach();
        int width = this.getUI().getPage().getBrowserWindowWidth();
        int height = this.getUI().getPage().getBrowserWindowHeight();
        int browserWidth = (int)(0.8 * (double)width);
        int browserHeight = (int)(0.8 * (double)height);
        int windowWidth = browserWidth + 50;
        int windowHeight = browserHeight + 110;
        this.setWidth(windowWidth, Sizeable.Unit.PIXELS);
        this.setHeight(windowHeight, Sizeable.Unit.PIXELS);
        this.setPositionX((width - windowWidth) / 2);
        this.setPositionY((height - windowHeight) / 2);
        this.infoBrowser.setType(2);
        this.infoBrowser.setWidth((float)browserWidth, Sizeable.Unit.PIXELS);
        this.infoBrowser.setHeight((float)browserHeight, Sizeable.Unit.PIXELS);
    }

    public static interface LabelCreator {
        public String getLabel();
    }
}

