/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.rrd.tcp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.opennms.netmgt.rrd.RrdDataSource;
import org.opennms.netmgt.rrd.RrdGraphDetails;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.tcp.RrdOutputSocket;

public class TcpRrdStrategy
implements RrdStrategy<RrdDefinition, RrdOutputSocketWithFilename> {
    private String m_host = null;
    private int m_port = 0;

    public String getHost() {
        return this.m_host;
    }

    public void setConfigurationProperties(Properties configurationParameters) {
    }

    public void setHost(String host) {
        this.m_host = host;
    }

    public int getPort() {
        return this.m_port;
    }

    public void setPort(int port) {
        this.m_port = port;
    }

    public String getDefaultFileExtension() {
        return "";
    }

    public RrdDefinition createDefinition(String creator, String directory, String rrdName, int step, List<RrdDataSource> dataSources, List<String> rraList) throws Exception {
        return new RrdDefinition(directory, rrdName);
    }

    public void createFile(RrdDefinition rrdDef) throws Exception {
    }

    public RrdOutputSocketWithFilename openFile(String fileName) throws Exception {
        return new RrdOutputSocketWithFilename(new RrdOutputSocket(this.m_host, this.m_port), fileName);
    }

    public void updateFile(RrdOutputSocketWithFilename rrd, String owner, String data) throws Exception {
        rrd.getSocket().addData(rrd.getFilename(), owner, data);
    }

    public void closeFile(RrdOutputSocketWithFilename rrd) throws Exception {
        rrd.getSocket().writeData();
    }

    public Double fetchLastValue(String rrdFile, String ds, int interval) throws NumberFormatException {
        return Double.NaN;
    }

    public Double fetchLastValue(String rrdFile, String ds, String consolidationFunction, int interval) throws NumberFormatException {
        return Double.NaN;
    }

    public Double fetchLastValueInRange(String rrdFile, String ds, int interval, int range) throws NumberFormatException {
        return Double.NaN;
    }

    public InputStream createGraph(String command, File workDir) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support graphing.");
    }

    public RrdGraphDetails createGraphReturnDetails(String command, File workDir) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support graphing.");
    }

    public int getGraphLeftOffset() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support graphing.");
    }

    public int getGraphRightOffset() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support graphing.");
    }

    public int getGraphTopOffsetWithText() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support graphing.");
    }

    public String getStats() {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not support graphing.");
    }

    public void promoteEnqueuedFiles(Collection<String> rrdFiles) {
    }

    public static class RrdDefinition {
        private final String m_directory;
        private final String m_rrdName;

        public RrdDefinition(String directory, String rrdName) {
            this.m_directory = directory;
            this.m_rrdName = rrdName;
        }

        public String getPath() {
            return this.m_directory + File.separator + this.m_rrdName;
        }
    }

    public static class RrdOutputSocketWithFilename {
        private final RrdOutputSocket m_socket;
        private final String m_filename;

        public RrdOutputSocketWithFilename(RrdOutputSocket socket, String filename) {
            this.m_socket = socket;
            this.m_filename = filename;
        }

        public RrdOutputSocket getSocket() {
            return this.m_socket;
        }

        public String getFilename() {
            return this.m_filename;
        }
    }
}

