/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.detector.datagram.client;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import org.opennms.netmgt.provision.support.Client;
import org.opennms.netmgt.provision.support.ntp.NtpMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class NtpClient
implements Client<NtpMessage, DatagramPacket> {
    private static final Logger LOG = LoggerFactory.getLogger(NtpClient.class);
    private DatagramSocket m_socket;
    private int m_port;
    private InetAddress m_address;

    public void close() {
        this.m_socket.close();
    }

    public void connect(InetAddress address, int port, int timeout) throws IOException, Exception {
        LOG.debug("Address: {}, port: {}, timeout: {}", new Object[]{address, port, timeout});
        this.m_socket = new DatagramSocket();
        this.m_socket.setSoTimeout(timeout);
        this.setAddress(address);
        this.setPort(port);
    }

    public DatagramPacket receiveBanner() throws IOException, Exception {
        throw new UnsupportedOperationException("Client<NtpMessage,DatagramPacket>.receiveBanner is not yet implemented");
    }

    public DatagramPacket sendRequest(NtpMessage request) throws IOException, Exception {
        byte[] buf = new NtpMessage().toByteArray();
        this.m_socket.send(new DatagramPacket(buf, buf.length, this.getAddress(), this.getPort()));
        byte[] data = new byte[512];
        DatagramPacket packet = new DatagramPacket(data, data.length);
        this.m_socket.receive(packet);
        return packet;
    }

    protected void setAddress(InetAddress address) {
        this.m_address = address;
    }

    public InetAddress getAddress() {
        return this.m_address;
    }

    protected void setPort(int port) {
        this.m_port = port;
    }

    public int getPort() {
        return this.m_port;
    }
}

