/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans;

import com.vaadin.server.FontAwesome;
import com.vaadin.v7.data.Item;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.features.vaadin.jmxconfiggenerator.Config;
import org.opennms.features.vaadin.jmxconfiggenerator.data.Reflections;
import org.opennms.features.vaadin.jmxconfiggenerator.data.StringRenderer;
import org.opennms.features.vaadin.jmxconfiggenerator.ui.mbeans.MBeansHelper;
import org.opennms.netmgt.config.collectd.jmx.CompAttrib;
import org.opennms.netmgt.config.collectd.jmx.Mbean;

class MBeansItemStrategyHandler {
    private final Map<Class<?>, ItemStrategy> propertyStrategy = new HashMap();
    private final Map<Class<?>, StringRenderer<?>> extractors = new HashMap();

    public MBeansItemStrategyHandler() {
        this.propertyStrategy.put(Map.Entry.class, new EntryItemStrategy());
        this.propertyStrategy.put(Mbean.class, new MBeanItemStrategy());
        this.propertyStrategy.put(String.class, new StringItemStrategy());
        this.propertyStrategy.put(CompAttrib.class, new CompAttribItemStrategy());
        this.extractors.put(String.class, new StringRenderer<String>(){

            @Override
            public String render(String input) {
                return input;
            }
        });
        this.extractors.put(Mbean.class, new StringRenderer<Mbean>(){

            @Override
            public String render(Mbean input) {
                return MBeansHelper.getLeafLabel(input);
            }
        });
        this.extractors.put(Map.Entry.class, new StringRenderer<Map.Entry>(){

            @Override
            public String render(Map.Entry entry) {
                return (String)entry.getValue();
            }
        });
        this.extractors.put(CompAttrib.class, new StringRenderer<CompAttrib>(){

            @Override
            public String render(CompAttrib input) {
                return input.getName();
            }
        });
    }

    protected ItemStrategy getStrategy(Class<?> clazz) {
        return MBeansItemStrategyHandler.getValueForClass(this.propertyStrategy, clazz);
    }

    protected StringRenderer getStringRenderer(Class<?> clazz) {
        return MBeansItemStrategyHandler.getValueForClass(this.extractors, clazz);
    }

    protected void setItemProperties(Item item, Object itemId) {
        if (itemId == null || item == null) {
            return;
        }
        ItemStrategy strategy = this.getStrategy(itemId.getClass());
        strategy.setItemProperties(item, itemId);
    }

    protected static <T> T getValueForClass(Map<Class<?>, T> map, Class<?> clazz) {
        List<Class<?>> classes = Reflections.buildClassHierarchy(clazz);
        for (int i = classes.size() - 1; i >= 0; --i) {
            if (map.get(classes.get(i)) == null) continue;
            return map.get(classes.get(i));
        }
        return null;
    }

    private static class EntryItemStrategy
    implements ItemStrategy {
        private EntryItemStrategy() {
        }

        @Override
        public void setItemProperties(Item item, Object itemId) {
            item.getItemProperty((Object)"icon").setValue((Object)Config.Icons.DUMMY);
            item.getItemProperty((Object)"label").setValue(((Map.Entry)itemId).getValue());
            item.getItemProperty((Object)"caption").setValue(((Map.Entry)itemId).getValue());
        }
    }

    private static class MBeanItemStrategy
    implements ItemStrategy {
        private MBeanItemStrategy() {
        }

        @Override
        public void setItemProperties(Item item, Object itemId) {
            if (!(itemId instanceof Mbean)) {
                return;
            }
            Mbean bean = (Mbean)itemId;
            item.getItemProperty((Object)"icon").setValue((Object)FontAwesome.SITEMAP);
            item.getItemProperty((Object)"caption").setValue((Object)bean.getObjectname());
            item.getItemProperty((Object)"label").setValue((Object)MBeansHelper.getLeafLabel(bean));
        }
    }

    private static class StringItemStrategy
    implements ItemStrategy {
        private StringItemStrategy() {
        }

        @Override
        public void setItemProperties(Item item, Object itemId) {
            item.getItemProperty((Object)"icon").setValue((Object)Config.Icons.DUMMY);
            item.getItemProperty((Object)"label").setValue(itemId);
            item.getItemProperty((Object)"caption").setValue(itemId);
        }
    }

    private static class CompAttribItemStrategy
    implements ItemStrategy {
        private CompAttribItemStrategy() {
        }

        @Override
        public void setItemProperties(Item item, Object itemId) {
            item.getItemProperty((Object)"icon").setValue((Object)Config.Icons.DUMMY);
            item.getItemProperty((Object)"label").setValue((Object)((CompAttrib)itemId).getName());
            item.getItemProperty((Object)"caption").setValue((Object)((CompAttrib)itemId).getName());
        }
    }

    protected static interface ItemStrategy {
        public void setItemProperties(Item var1, Object var2);
    }
}

