/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import java.util.Objects;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.ErrorStatusException;
import org.opennms.netmgt.snmp.NamedSnmpVar;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CiscoVtpTracker
extends AggregateTracker {
    private static final Logger LOG = LoggerFactory.getLogger(CiscoVtpTracker.class);
    public static final String CISCO_VTP_VERSION = "vtpVersion";
    public static final String CISCO_VTP_VERSION_OID = ".1.3.6.1.4.1.9.9.46.1.1.1";
    public static final NamedSnmpVar[] ms_elemList = new NamedSnmpVar[]{new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", "vtpVersion", ".1.3.6.1.4.1.9.9.46.1.1.1")};
    private final SnmpStore m_store = new SnmpStore(ms_elemList);

    public CiscoVtpTracker() {
        super((Collectable[])NamedSnmpVar.getTrackersFor((NamedSnmpVar[])ms_elemList));
    }

    protected void storeResult(SnmpResult res) {
        this.m_store.storeResult(res);
    }

    protected void reportGenErr(String msg) {
        LOG.warn("Error retrieving vtpVersion: {}", (Object)msg);
    }

    protected void reportNoSuchNameErr(String msg) {
        LOG.info("Error retrieving vtpVersion: {}", (Object)msg);
    }

    protected void reportFatalErr(ErrorStatusException ex) {
        LOG.warn("Error retrieving vtpVersion: {}", (Object)ex.getMessage(), (Object)ex);
    }

    public Integer getVtpVersion() {
        return this.m_store.getInt32(CISCO_VTP_VERSION);
    }

    public VtpVersion decodeVtpVersion() {
        return VtpVersion.getByValue(this.m_store.getInt32(CISCO_VTP_VERSION));
    }

    public void printSnmpData() {
        System.out.printf("\t\t%s (%s)= %s (%s)\n", new Object[]{CISCO_VTP_VERSION_OID, CISCO_VTP_VERSION, this.getVtpVersion(), this.decodeVtpVersion()});
    }

    public static enum VtpVersion {
        one(1),
        two(2),
        none(3),
        three(4);

        private final Integer value;

        private VtpVersion(Integer value) {
            this.value = value;
        }

        public Integer getValue() {
            return this.value;
        }

        public static VtpVersion getByValue(Integer vtpVersion) {
            for (VtpVersion version : VtpVersion.values()) {
                if (!Objects.equals(version.getValue(), vtpVersion)) continue;
                return version;
            }
            return null;
        }
    }
}

