/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.config;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.features.apilayer.config.ConfigExtensionManager;
import org.opennms.integration.api.v1.config.datacollection.Parameter;
import org.opennms.integration.api.v1.config.datacollection.ResourceTypesExtension;
import org.opennms.netmgt.config.datacollection.PersistenceSelectorStrategy;
import org.opennms.netmgt.config.datacollection.ResourceType;
import org.opennms.netmgt.config.datacollection.ResourceTypes;
import org.opennms.netmgt.config.datacollection.StorageStrategy;

public class ResourceTypesExtensionManager
extends ConfigExtensionManager<ResourceTypesExtension, ResourceTypes> {
    public ResourceTypesExtensionManager() {
        super(ResourceTypes.class, new ResourceTypes());
    }

    @Override
    protected ResourceTypes getConfigForExtensions(Set<ResourceTypesExtension> extensions) {
        ResourceTypes resourceTypes = new ResourceTypes();
        List resourceTypeList = extensions.stream().flatMap(r -> ResourceTypesExtensionManager.toResourceTypeList(r.getResourceTypes()).stream()).collect(Collectors.toList());
        resourceTypes.setResourceTypes(resourceTypeList);
        return resourceTypes;
    }

    @Override
    protected void triggerReload() {
    }

    public static List<ResourceType> toResourceTypeList(List<org.opennms.integration.api.v1.config.datacollection.ResourceType> resourceTypes) {
        return resourceTypes.stream().map(ResourceTypesExtensionManager::toResourceType).collect(Collectors.toList());
    }

    public static ResourceType toResourceType(org.opennms.integration.api.v1.config.datacollection.ResourceType rt) {
        ResourceType resourceType = new ResourceType();
        resourceType.setLabel(rt.getLabel());
        resourceType.setName(rt.getName());
        resourceType.setResourceLabel(rt.getResourceLabel());
        if (rt.getStorageStrategy() != null) {
            StorageStrategy storageStrategy = new StorageStrategy();
            storageStrategy.setClazz(rt.getStorageStrategy().getClazz());
            storageStrategy.setParameters(rt.getStorageStrategy().getParameters().stream().map(ResourceTypesExtensionManager::toParameter).collect(Collectors.toList()));
            resourceType.setStorageStrategy(storageStrategy);
        }
        if (rt.getPersistenceSelectorStrategy() != null) {
            PersistenceSelectorStrategy selectorStrategy = new PersistenceSelectorStrategy();
            selectorStrategy.setClazz(rt.getPersistenceSelectorStrategy().getClazz());
            selectorStrategy.setParameters(rt.getPersistenceSelectorStrategy().getParameters().stream().map(ResourceTypesExtensionManager::toParameter).collect(Collectors.toList()));
            resourceType.setPersistenceSelectorStrategy(selectorStrategy);
        }
        return resourceType;
    }

    public static org.opennms.netmgt.collection.api.Parameter toParameter(final Parameter parameter) {
        return new org.opennms.netmgt.collection.api.Parameter(){

            public String getKey() {
                return parameter.getKey();
            }

            public String getValue() {
                return parameter.getValue();
            }
        };
    }
}

