/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.support;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.provision.DetectRequest;
import org.opennms.netmgt.provision.DetectResults;
import org.opennms.netmgt.provision.SyncServiceDetector;
import org.opennms.netmgt.provision.support.AbstractDetector;
import org.opennms.netmgt.provision.support.DetectResultsImpl;

public abstract class AgentBasedSyncAbstractDetector<T>
extends AbstractDetector
implements SyncServiceDetector {
    public static final String HAS_MULTIPLE_AGENT_CONFIGS = "hasMultipleAgentConfigs";

    public AgentBasedSyncAbstractDetector(String serviceName, int port, int defaultTimeout, int defaultRetries) {
        super(serviceName, port, defaultTimeout, defaultRetries);
    }

    protected AgentBasedSyncAbstractDetector(String serviceName, int port) {
        super(serviceName, port);
    }

    @Override
    public DetectResults detect(DetectRequest request) {
        Map<String, String> runTimeAttributes = request.getRuntimeAttributes();
        if (AgentBasedSyncAbstractDetector.hasMultipleAgentConfigs(runTimeAttributes)) {
            return new DetectResultsImpl(this.isServiceDetected(request.getAddress(), this.getListOfAgentConfigs(request)));
        }
        return new DetectResultsImpl(this.isServiceDetected(request.getAddress(), this.getAgentConfig(request)));
    }

    public abstract T getAgentConfig(DetectRequest var1);

    public abstract boolean isServiceDetected(InetAddress var1, T var2);

    public List<T> getListOfAgentConfigs(DetectRequest request) {
        ArrayList<T> agentConfigList = new ArrayList<T>();
        agentConfigList.add(this.getAgentConfig(request));
        return agentConfigList;
    }

    public boolean isServiceDetected(InetAddress address, List<T> agentConfigList) {
        return agentConfigList.stream().anyMatch(agentConfig -> this.isServiceDetected(address, agentConfig));
    }

    protected static boolean hasMultipleAgentConfigs(Map<String, String> runTimeAttributes) {
        return runTimeAttributes != null && runTimeAttributes.get(HAS_MULTIPLE_AGENT_CONFIGS) != null && runTimeAttributes.get(HAS_MULTIPLE_AGENT_CONFIGS).equals(Boolean.toString(true));
    }
}

