/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.api;

import java.util.List;
import java.util.Objects;

public abstract class QueryUtils {
    private QueryUtils() {
    }

    public static Object ilike(String input) {
        return String.format("%%%s%%", input);
    }

    public static boolean equals(Integer checkMe, String input) {
        if (checkMe == null) {
            return false;
        }
        return checkMe.toString().equals(input);
    }

    public static boolean matches(String checkMe, String input) {
        if (checkMe == null) {
            return false;
        }
        return checkMe.toLowerCase().contains(input.toLowerCase());
    }

    public static boolean matches(List<String> checkMe, String input) {
        if (checkMe != null) {
            return checkMe.stream().anyMatch(it -> QueryUtils.matches(it, input));
        }
        return false;
    }

    public static <T> List<T> shrink(List<T> input, int maxResults) {
        Objects.requireNonNull(input);
        List<T> subList = input.subList(0, Math.min(maxResults, input.size()));
        return subList;
    }

    public static String getFirstMatch(List<String> aliases, String input) {
        return aliases.stream().filter(alias -> QueryUtils.matches(alias, input)).findFirst().orElseThrow(() -> new RuntimeException("Could not find any match"));
    }
}

