/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.utils.filter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.opennms.core.utils.StringUtils;

public class CheckboxFilterUtils {
    public static final String ARRAY_DELIMITER = ",";
    public static final String POSITIVE_CHECKBOX_VALUE = "on";
    private static final Pattern MULTI_CHECKBOX_PATTERN = Pattern.compile("[a-zA-Z]+-\\d+=1");

    public static boolean isCheckboxToggled(String[] tokenizedFilterString) {
        return tokenizedFilterString != null && StringUtils.equalsTrimmed((String)tokenizedFilterString[1], (String)POSITIVE_CHECKBOX_VALUE);
    }

    public static String[] handleCheckboxDuplication(String[] filterStrings) {
        if (filterStrings == null) {
            return filterStrings;
        }
        Map<String, List<String>> selectedCheckboxes = CheckboxFilterUtils.dedupCheckboxSelections(filterStrings);
        if (selectedCheckboxes.isEmpty()) {
            return filterStrings;
        }
        return CheckboxFilterUtils.replaceCheckboxValues(filterStrings, selectedCheckboxes);
    }

    private static Map<String, List<String>> dedupCheckboxSelections(String[] filterStrings) {
        HashMap<String, List<String>> selectedCheckboxes = new HashMap<String, List<String>>();
        for (String filterString : filterStrings) {
            if (!MULTI_CHECKBOX_PATTERN.matcher(filterString).matches()) continue;
            String[] filterStringHyphenSplit = filterString.split("-");
            String type = filterStringHyphenSplit[0];
            String remainder = filterStringHyphenSplit[1];
            String idStr = remainder.split("=")[0];
            if (selectedCheckboxes.containsKey(type)) {
                ((List)selectedCheckboxes.get(type)).add(idStr);
                continue;
            }
            ArrayList<String> checkedIds = new ArrayList<String>();
            checkedIds.add(idStr);
            selectedCheckboxes.put(type, checkedIds);
        }
        return selectedCheckboxes;
    }

    private static String[] replaceCheckboxValues(String[] filterStrings, Map<String, List<String>> selectedCheckboxes) {
        List<String> collectedFilterList = Arrays.stream(filterStrings).filter(thisFilterString -> {
            for (String selectedKey : selectedCheckboxes.keySet()) {
                if (!thisFilterString.startsWith(selectedKey + "-")) continue;
                return false;
            }
            return true;
        }).collect(Collectors.toList());
        for (String selectedKey : selectedCheckboxes.keySet()) {
            List<String> selectedIds = selectedCheckboxes.get(selectedKey);
            String joinedIds = String.join((CharSequence)ARRAY_DELIMITER, selectedIds);
            String checkboxFormattedFilter = String.format("%s=%s", selectedKey, joinedIds);
            collectedFilterList.add(checkboxFormattedFilter);
        }
        return collectedFilterList.toArray(new String[0]);
    }
}

