/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.tags;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.SimpleTagSupport;
import org.opennms.web.alert.Alert;
import org.opennms.web.alert.AlertType;
import org.springframework.web.servlet.ModelAndView;

public class AlertTag
extends SimpleTagSupport {
    private static final String REQUEST_PARAMETER_NAME = "#__ALERTS__#";
    private static final String TEMPLATE = "<div class=\"alert {0}\">{1}</div>";

    public static void addAlertToRequest(ModelAndView modelAndView, String message) {
        AlertTag.addAlertToRequest(modelAndView, message, AlertType.INFO);
    }

    public static void addAlertToRequest(ModelAndView modelAndView, String message, AlertType alertType) {
        if (modelAndView.getModel().get(REQUEST_PARAMETER_NAME) == null) {
            modelAndView.addObject(REQUEST_PARAMETER_NAME, new ArrayList());
        }
        Collection alerts = (Collection)modelAndView.getModel().get(REQUEST_PARAMETER_NAME);
        alerts.add(new Alert(message, alertType));
    }

    private static String getStyle(AlertType type) {
        switch (type) {
            case INFO: {
                return "alert-info";
            }
            case SUCCESS: {
                return "alert-success";
            }
        }
        return "alert-danger";
    }

    public void doTag() throws JspException, IOException {
        Object alertsObject = this.getJspContext().findAttribute(REQUEST_PARAMETER_NAME);
        if (alertsObject == null) {
            return;
        }
        if (!(alertsObject instanceof Collection)) {
            return;
        }
        Collection alerts = (Collection)alertsObject;
        for (Alert eachAlert : alerts) {
            String alertOutput = MessageFormat.format(TEMPLATE, AlertTag.getStyle(eachAlert.getType()), eachAlert.getMessage());
            this.getJspContext().getOut().write(alertOutput);
        }
    }
}

