/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.filter;

import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.opennms.core.utils.StringUtils;

public abstract class FilterUtil {
    public static String toFilterURL(String[] filters) {
        return FilterUtil.toFilterURL(filters != null ? Arrays.asList(filters) : new ArrayList<String>());
    }

    public static String toFilterURL(List<String> filters) {
        StringBuilder buffer = new StringBuilder();
        if (filters != null) {
            for (int i = 0; i < filters.size(); ++i) {
                if (i == 0) {
                    buffer.append("filter=");
                } else {
                    buffer.append("&amp;filter=");
                }
                String filterString = filters.get(i);
                buffer.append(URLEncoder.encode(filterString));
            }
        }
        return buffer.toString();
    }

    public static String[] parse(String filterString) {
        String decodedString = URLDecoder.decode(filterString, StandardCharsets.UTF_8);
        return (String[])Arrays.stream(FilterUtil.getFilterParameters(decodedString)).map(fp -> fp.replace("filter=", "")).distinct().toArray(String[]::new);
    }

    public static String[] getFilterParameters(String filterString) {
        if (StringUtils.isEmpty((String)filterString)) {
            return new String[0];
        }
        if (filterString.contains("&amp;")) {
            return filterString.split("&amp;");
        }
        return filterString.split("&");
    }
}

