/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller.event;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.model.OnmsFilterFavorite;
import org.opennms.web.alert.AlertType;
import org.opennms.web.event.AcknowledgeType;
import org.opennms.web.event.Event;
import org.opennms.web.event.EventIdNotFoundException;
import org.opennms.web.event.EventQueryParms;
import org.opennms.web.event.EventUtil;
import org.opennms.web.event.SortStyle;
import org.opennms.web.event.WebEventRepository;
import org.opennms.web.event.filter.EventCriteria;
import org.opennms.web.event.filter.EventIdFilter;
import org.opennms.web.event.filter.EventIdListFilter;
import org.opennms.web.filter.Filter;
import org.opennms.web.filter.FilterUtil;
import org.opennms.web.filter.NormalizedQueryParameters;
import org.opennms.web.services.FilterFavoriteService;
import org.opennms.web.servlet.MissingParameterException;
import org.opennms.web.tags.AlertTag;
import org.opennms.web.tags.filters.EventFilterCallback;
import org.opennms.web.tags.filters.FilterCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;
import org.springframework.web.servlet.view.RedirectView;

public class EventController
extends MultiActionController
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(EventController.class);
    private static final int DEFAULT_MULTIPLE = 0;
    private static final int DEFAULT_SHORT_LIMIT = 20;
    private static final int DEFAULT_LONG_LIMIT = 10;
    private static final AcknowledgeType DEFAULT_ACKNOWLEDGE_TYPE = AcknowledgeType.UNACKNOWLEDGED;
    private static final SortStyle DEFAULT_SORT_STYLE = SortStyle.ID;
    private FilterCallback m_callback;
    @Autowired
    private FilterFavoriteService favoriteService;
    @Autowired
    private WebEventRepository m_webEventRepository;
    private boolean m_showEventCount = Boolean.getBoolean("opennms.eventlist.showCount");

    @Transactional
    public ModelAndView handleRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return super.handleRequest(request, response);
    }

    public ModelAndView list(HttpServletRequest request, HttpServletResponse response) throws Exception {
        OnmsFilterFavorite favorite = this.getFavorite(request.getParameter("favoriteId"), request.getRemoteUser(), FilterUtil.parse(request.getQueryString() == null ? "" : request.getQueryString()));
        return this.list(request, favorite);
    }

    private ModelAndView list(HttpServletRequest request, OnmsFilterFavorite favorite) {
        AcknowledgeType ackType = this.getAcknowledgeType(request);
        ModelAndView modelAndView = this.createListModelAndView(request, this.getFilterCallback().parse(FilterUtil.parse(request.getQueryString() == null ? "" : request.getQueryString())), ackType);
        modelAndView.addObject("favorite", (Object)favorite);
        modelAndView.setViewName("event/list");
        return modelAndView;
    }

    public ModelAndView detail(HttpServletRequest request, HttpServletResponse response) throws Exception {
        long eventId;
        String idString = request.getParameter("id");
        try {
            eventId = WebSecurityUtils.safeParseLong((String)idString);
        }
        catch (NumberFormatException e) {
            throw new EventIdNotFoundException("Could not parse event ID '" + idString + "' to integer.", idString);
        }
        ModelAndView modelAndView = this.createModelAndView(request, new EventIdFilter(eventId));
        modelAndView.setViewName("event/detail");
        modelAndView.addObject("eventId", (Object)idString);
        return modelAndView;
    }

    public ModelAndView index(HttpServletRequest request, HttpServletResponse response) throws Exception {
        List<OnmsFilterFavorite> userFilterList = this.favoriteService.getFavorites(request.getRemoteUser(), OnmsFilterFavorite.Page.EVENT);
        ModelAndView modelAndView = new ModelAndView("event/index");
        modelAndView.addObject("favorites", (Object)userFilterList.toArray());
        modelAndView.addObject("callback", (Object)this.getFilterCallback());
        return modelAndView;
    }

    public ModelAndView createFavorite(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String error = null;
        try {
            OnmsFilterFavorite favorite = this.favoriteService.createFavorite(request.getRemoteUser(), request.getParameter("favoriteName"), FilterUtil.toFilterURL(request.getParameterValues("filter")), OnmsFilterFavorite.Page.EVENT);
            if (favorite != null) {
                ModelAndView successView = this.list(request, favorite);
                return successView;
            }
            error = "An error occured while creating the favorite";
        }
        catch (FilterFavoriteService.FilterFavoriteException ex) {
            error = ex.getMessage();
        }
        ModelAndView errorView = this.list(request, (OnmsFilterFavorite)null);
        AlertTag.addAlertToRequest(errorView, error, AlertType.ERROR);
        return errorView;
    }

    public ModelAndView deleteFavorite(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String favoriteId = request.getParameter("favoriteId");
        boolean success = this.favoriteService.deleteFavorite(favoriteId, request.getRemoteUser());
        ModelAndView resultView = this.list(request, (OnmsFilterFavorite)null);
        resultView.addObject("favorite", null);
        if (!StringUtils.isEmpty((String)request.getParameter("redirect"))) {
            resultView.setViewName(request.getParameter("redirect"));
        }
        if (!success) {
            AlertTag.addAlertToRequest(resultView, "Favorite couldn't be deleted.", AlertType.ERROR);
        } else {
            AlertTag.addAlertToRequest(resultView, "Favorite deleted successfully.", AlertType.SUCCESS);
        }
        return resultView;
    }

    public ModelAndView acknowledge(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] eventIdStrings = request.getParameterValues("event");
        String action = request.getParameter("actionCode");
        if (eventIdStrings == null) {
            throw new MissingParameterException("event", new String[]{"event", "actionCode"});
        }
        if (action == null) {
            throw new MissingParameterException("actionCode", new String[]{"event", "actionCode"});
        }
        ArrayList<EventIdListFilter> filters = new ArrayList<EventIdListFilter>();
        filters.add(new EventIdListFilter(WebSecurityUtils.safeParseLong((String[])eventIdStrings)));
        EventCriteria criteria = new EventCriteria(filters.toArray(new Filter[0]));
        LOG.debug("criteria = {}, action = {}", (Object)criteria, (Object)action);
        if (action.equals(AcknowledgeType.ACKNOWLEDGED.getShortName())) {
            this.m_webEventRepository.acknowledgeMatchingEvents(request.getRemoteUser(), new Date(), criteria);
        } else if (action.equals(AcknowledgeType.UNACKNOWLEDGED.getShortName())) {
            this.m_webEventRepository.unacknowledgeMatchingEvents(criteria);
        } else {
            throw new ServletException("Unknown acknowledge action: " + action);
        }
        return this.getRedirectView(request);
    }

    public ModelAndView acknowledgeByFilter(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String[] filterStrings = request.getParameterValues("filter");
        String action = request.getParameter("actionCode");
        if (filterStrings == null) {
            filterStrings = new String[]{};
        }
        if (action == null) {
            throw new MissingParameterException("actionCode", new String[]{"filter", "actionCode"});
        }
        ArrayList<Filter> filterArray = new ArrayList<Filter>();
        for (String filterString : filterStrings) {
            Filter filter = EventUtil.getFilter(filterString, this.getServletContext());
            if (filter == null) continue;
            filterArray.add(filter);
        }
        Filter[] filters = filterArray.toArray(new Filter[filterArray.size()]);
        EventCriteria criteria = new EventCriteria(filters);
        if (action.equals(AcknowledgeType.ACKNOWLEDGED.getShortName())) {
            this.m_webEventRepository.acknowledgeMatchingEvents(request.getRemoteUser(), new Date(), criteria);
        } else if (action.equals(AcknowledgeType.UNACKNOWLEDGED.getShortName())) {
            this.m_webEventRepository.unacknowledgeMatchingEvents(criteria);
        } else {
            throw new ServletException("Unknown acknowledge action: " + action);
        }
        return this.getRedirectView(request);
    }

    private ModelAndView getRedirectView(HttpServletRequest request) {
        String redirectParms = request.getParameter("redirectParms");
        String redirect = request.getParameter("redirect");
        Object viewName = redirect != null ? redirect : (redirectParms == null || "".equals(redirectParms) || "null".equals(redirectParms) ? "/event/list" : "/event/list?" + redirectParms);
        RedirectView redirectView = new RedirectView((String)viewName);
        return new ModelAndView((View)redirectView);
    }

    private String getDisplay(HttpServletRequest request) {
        return this.getQueryParameter(request, "display");
    }

    private int getLimit(HttpServletRequest request) {
        int limit;
        String display = this.getDisplay(request);
        String limitString = this.getQueryParameter(request, "limit");
        int n = limit = "long".equals(display) ? 10 : 20;
        if (limitString != null) {
            try {
                int newlimit = WebSecurityUtils.safeParseInt((String)limitString);
                if (newlimit > 0) {
                    limit = newlimit;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return limit;
    }

    private int getMultiple(HttpServletRequest request) {
        String multipleString = this.getQueryParameter(request, "multiple");
        int multiple = 0;
        if (multipleString != null) {
            try {
                multiple = Math.max(0, WebSecurityUtils.safeParseInt((String)multipleString));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return multiple;
    }

    private SortStyle getSortStyle(HttpServletRequest request) {
        SortStyle temp;
        String sortStyleString = this.getQueryParameter(request, "sortby");
        SortStyle sortStyle = DEFAULT_SORT_STYLE;
        if (sortStyleString != null && (temp = SortStyle.getSortStyle(sortStyleString)) != null) {
            sortStyle = temp;
        }
        return sortStyle;
    }

    private AcknowledgeType getAcknowledgeType(HttpServletRequest request) {
        AcknowledgeType temp;
        String ackTypeString = this.getQueryParameter(request, "acktype");
        AcknowledgeType ackType = DEFAULT_ACKNOWLEDGE_TYPE;
        if (ackTypeString != null && (temp = AcknowledgeType.getAcknowledgeType(ackTypeString)) != null) {
            ackType = temp;
        }
        return ackType;
    }

    private String getQueryParameter(HttpServletRequest request, String key) {
        String queryParams = request.getQueryString();
        if (StringUtils.isNotEmpty((String)queryParams)) {
            if (queryParams.contains("&amp;")) {
                String[] querySplit;
                for (String queryParam : querySplit = queryParams.split("&amp;")) {
                    String[] queryParamSplit = queryParam.split("=");
                    if (!queryParamSplit[0].equalsIgnoreCase(key)) continue;
                    return queryParamSplit[1];
                }
            } else {
                return request.getParameter(key);
            }
        }
        return null;
    }

    private EventQueryParms createEventQueryParms(HttpServletRequest request, List<Filter> filterList, AcknowledgeType ackType) {
        EventQueryParms parms = new EventQueryParms();
        parms.ackType = ackType;
        parms.display = this.getDisplay(request);
        parms.filters = filterList;
        parms.limit = this.getLimit(request);
        parms.multiple = this.getMultiple(request);
        parms.sortStyle = this.getSortStyle(request);
        return parms;
    }

    private ModelAndView createModelAndView(HttpServletRequest request, Filter singleFilter) {
        ArrayList<Filter> filterList = new ArrayList<Filter>();
        filterList.add(singleFilter);
        return this.createListModelAndView(request, filterList, null);
    }

    private ModelAndView createListModelAndView(HttpServletRequest request, List<Filter> filterList, AcknowledgeType ackType) {
        EventQueryParms parms = this.createEventQueryParms(request, filterList, ackType);
        EventCriteria queryCriteria = new EventCriteria(parms);
        Event[] events = this.m_webEventRepository.getMatchingEvents(queryCriteria);
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.addObject("events", (Object)events);
        modelAndView.addObject("parms", (Object)new NormalizedQueryParameters(parms));
        modelAndView.addObject("callback", (Object)this.getFilterCallback());
        modelAndView.addObject("favorites", (Object)this.favoriteService.getFavorites(request.getRemoteUser(), OnmsFilterFavorite.Page.EVENT).toArray());
        if (this.m_showEventCount) {
            EventCriteria countCriteria = new EventCriteria(filterList, ackType);
            modelAndView.addObject("eventCount", (Object)this.m_webEventRepository.countMatchingEvents(countCriteria));
        } else {
            modelAndView.addObject("eventCount", (Object)-1);
        }
        return modelAndView;
    }

    private OnmsFilterFavorite getFavorite(String favoriteId, String username, String[] filters) {
        if (favoriteId != null) {
            return this.favoriteService.getFavorite(favoriteId, username, this.getFilterCallback().toFilterString(filters));
        }
        return null;
    }

    private FilterCallback getFilterCallback() {
        if (this.m_callback == null) {
            this.m_callback = new EventFilterCallback(this.getServletContext());
        }
        return this.m_callback;
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)20, (String)"property defaultShortLimit must be set to a value greater than 0");
        Assert.isTrue((boolean)true, (String)"property defaultShortLimit must be set to a value greater than 0");
        Assert.notNull((Object)10, (String)"property defaultLongLimit must be set to a value greater than 0");
        Assert.isTrue((boolean)true, (String)"property defaultLongLimit must be set to a value greater than 0");
        Assert.notNull((Object)this.m_webEventRepository, (String)"webEventRepository must be set");
        Assert.notNull((Object)this.favoriteService, (String)"favoriteService must be set");
    }

    public void setWebEventRepository(WebEventRepository webEventRepository) {
        this.m_webEventRepository = webEventRepository;
    }

    public void setFavoriteService(FilterFavoriteService favoriteService) {
        this.favoriteService = favoriteService;
    }
}

