/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.controller;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;

public class RedirectRestricter {
    private final Set<String> allowedRedirects;

    private RedirectRestricter(RedirectRestricterBuilder builder) {
        this.allowedRedirects = builder.allowedRedirects;
    }

    public boolean isRedirectAllowed(String redirect) {
        if (redirect == null || redirect.isEmpty()) {
            return false;
        }
        String redirectWithoutParameters = new StringTokenizer(redirect, "?", false).nextToken();
        return this.allowedRedirects.contains(redirectWithoutParameters);
    }

    public String getRedirectOrNull(String redirect) {
        return this.isRedirectAllowed(redirect) ? redirect : null;
    }

    public static RedirectRestricterBuilder builder() {
        return new RedirectRestricterBuilder();
    }

    public static class RedirectRestricterBuilder {
        private final Set<String> allowedRedirects = new HashSet<String>();

        public RedirectRestricterBuilder allowRedirect(String allowedRedirect) {
            Objects.requireNonNull(allowedRedirect, "allowed redirect cannot be null.");
            if (allowedRedirect.isEmpty()) {
                throw new IllegalArgumentException("allowed redirect cannot be empty.");
            }
            this.allowedRedirects.add(allowedRedirect);
            return this;
        }

        public RedirectRestricter build() {
            return new RedirectRestricter(this);
        }
    }
}

