/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.alarm.filter;

import com.google.common.base.Objects;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.BooleanType;
import org.hibernate.type.Type;
import org.opennms.web.filter.Filter;
import org.opennms.web.filter.SQLType;

public class SituationFilter
implements Filter {
    public static final String TYPE = "situation";
    private final boolean value;

    public SituationFilter(boolean situation) {
        this.value = situation;
    }

    @Override
    public String getSql() {
        return " (SELECT COUNT(*)>0 FROM ALARM_SITUATIONS WHERE ALARM_SITUATIONS.SITUATION_ID = ALARMID) = " + (this.value ? "TRUE" : "FALSE") + " ";
    }

    @Override
    public String getParamSql() {
        return " (SELECT COUNT(*)>0 FROM ALARM_SITUATIONS WHERE ALARM_SITUATIONS.SITUATION_ID = ALARMID) = ? ";
    }

    @Override
    public int bindParam(PreparedStatement ps, int parameterIndex) throws SQLException {
        SQLType.BOOLEAN.bindParam(ps, parameterIndex, this.value);
        return 1;
    }

    @Override
    public String getDescription() {
        return String.format("%s=%s", TYPE, this.value);
    }

    @Override
    public String getTextDescription() {
        if (this.value) {
            return "Alarm is a situation";
        }
        return "Alarm is not a situation";
    }

    @Override
    public Criterion getCriterion() {
        return Restrictions.sqlRestriction((String)"(SELECT COUNT(*)>0 FROM ALARM_SITUATIONS WHERE ALARM_SITUATIONS.SITUATION_ID = {alias}.alarmId) = ? ", (Object)this.value, (Type)BooleanType.INSTANCE);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SituationFilter that = (SituationFilter)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.value});
    }
}

