/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.alarm.filter;

import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.opennms.web.filter.NoSubstringFilter;

public class NegativeNodeNameLikeFilter
extends NoSubstringFilter {
    public static final String TYPE = "nodenamelikeNOT";

    public NegativeNodeNameLikeFilter(String substring) {
        super(TYPE, "NODELABEL", "node.label", substring);
    }

    @Override
    public String getSQLTemplate() {
        return " ALARMID NOT IN (SELECT ALARMID FROM ALARMS JOIN NODE ON ALARMS.NODEID=NODE.NODEID WHERE NODE.NODELABEL ILIKE %s) ";
    }

    @Override
    public Criterion getCriterion() {
        return Restrictions.sqlRestriction((String)" {alias}.alarmid NOT IN (SELECT alarmid FROM alarms JOIN node ON alarms.nodeid=node.nodeid WHERE node.nodelabel ILIKE ?)", (Object[])new Object[]{this.getBoundValue((String)this.getValue())}, (Type[])new Type[]{StringType.INSTANCE});
    }

    @Override
    public String getTextDescription() {
        return "Node name not containing \"" + (String)this.getValue() + "\"";
    }

    @Override
    public String toString() {
        return "<NegativeNodeNameLikeFilter: " + this.getDescription() + ">";
    }

    public String getSubstring() {
        return (String)this.getValue();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NegativeNodeNameLikeFilter)) {
            return false;
        }
        return this.toString().equals(obj.toString());
    }
}

